% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LibOPF.R
\name{opf_split}
\alias{opf_split}
\title{Generates training, evaluation and test sets for the OPF classifier}
\usage{
opf_split(dataSet, training_p, evaluating_p, testing_p, normalize = 0)
}
\arguments{
\item{dataSet}{The data (subGraph object)}

\item{training_p}{Percentage for the training set size [0,1]}

\item{evaluating_p}{Percentage for the evaluation set size [0,1] (leave 0 in the case of no learning)}

\item{testing_p}{Percentage for the test set size [0,1]}

\item{normalize}{Distance normalization? 1- yes 0 - no}
}
\value{
Returns the training, evaluating and the testing objects
}
\description{
Generates training, evaluation and test sets for the OPF classifier
}
\examples{
dat <- opf_read_subGraph(system.file("extdata/boat.dat",package = "LibOPF"))
X <- opf_split(dat,0.5,0,0.5,0)
T <- X$training
T2 <- X$testing
Y <- opf_train(T)
class <- opf_classify(T2, Y$classifier)
acc <- opf_accuracy(T2, class)

}
