% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfast.R
\name{lfast}
\alias{lfast}
\title{Rating scale data (e.g. Likert scale) from a Scaled Beta Distribution}
\usage{
lfast(n, mean, sd, lowerbound, upperbound, items = 1)
}
\arguments{
\item{n}{(positive, int) number of observations to generate}

\item{mean}{(real) target mean}

\item{sd}{(real) target standard deviation}

\item{lowerbound}{(positive, int) lower bound (e.g. '1' for a 1-5 rating scale)}

\item{upperbound}{(positive, int) upper bound (e.g. '5' for a 1-5 rating scale)}

\item{items}{(positive, int) number of items in the rating scale. Default = 1}
}
\value{
a vector of simulated data approximating user-specified conditions.
}
\description{
\code{lfast()} generates random discrete values from a
(scaled Beta distribution) so the data replicate a rating scale -
for example,a 1-5 scale made from 5 items (questions) or 0-10
likelihood-of-purchase scale.
\code{lfast()} takes repeated samples selecting a vector that best
fits the desired moments, while \code{lfast()} takes just one sample.
\code{lfast()} is slightly slower than \code{lfast()}.
}
\examples{

x <- lfast(
  n = 256,
  mean = 4.0,
  sd = 1.0,
  lowerbound = 1,
  upperbound = 7,
  items = 6
)

x <- lfast(256, 2, 1.8, 0, 10)

}
