% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ColumnLinkedMatrix.R, R/RowLinkedMatrix.R
\name{as.ColumnLinkedMatrix}
\alias{as.ColumnLinkedMatrix}
\alias{as.ColumnLinkedMatrix.list}
\alias{as.RowLinkedMatrix}
\alias{as.RowLinkedMatrix.list}
\title{Converts an Object to a LinkedMatrix Object.}
\usage{
as.ColumnLinkedMatrix(x, ...)

\method{as.ColumnLinkedMatrix}{list}(x, ...)

as.RowLinkedMatrix(x, ...)

\method{as.RowLinkedMatrix}{list}(x, ...)
}
\arguments{
\item{x}{An object to convert to a \linkS4class{LinkedMatrix} object.}

\item{...}{Additional arguments.}
}
\value{
A \linkS4class{LinkedMatrix} object.
}
\description{
Converts an Object to a LinkedMatrix Object.
}
\examples{
m1 <- ff::ff(initdata = rnorm(50), dim = c(5, 10))
m2 <- bigmemory::big.matrix(init = rnorm(50), nrow = 5, ncol = 10)
m3 <- matrix(data = rnorm(50), nrow = 5, ncol = 10)

myList <- list(m1, m2, m3)

m <- as.ColumnLinkedMatrix(myList)
}
