% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subfunctionsIdentification.R
\name{combineChains}
\alias{combineChains}
\title{Combine chain fragments that could belong to the same precursor.}
\usage{
combineChains(candidates, nchains, sn1, sn2, sn3, sn4)
}
\arguments{
\item{candidates}{candidates data frame. Output of \link{findCandidates}.}

\item{nchains}{number of chains of the targeted lipid class.}

\item{sn1}{list of chain fragments identified for sn1 position. Output of
\link{chainFrags}.}

\item{sn2}{list of chain fragments identified for sn2 position. Output of
\link{chainFrags}. If required.}

\item{sn3}{list of chain fragments identified for sn3 position. Output of
\link{chainFrags}. If required.}

\item{sn4}{list of chain fragments identified for sn4 position. Output of
\link{chainFrags}. If required.}
}
\value{
List of data frames with candidate chains structures.
}
\description{
It calculates combinations of chain fragments that sum up the same number of
carbons and double bounds as the precursor.
}
\examples{
\dontrun{
devtools::install_github("maialba3/LipidMSdata2")

library(LipidMS)
dbs <- assignDB()

MS1 <- LipidMSdata2::msobjectDIAneg$peaklist$MS1
MS1 <- MS1[MS1$isotope \%in\% c("[M+0]"), !colnames(MS1) \%in\% c("isotope", "isoGroup")]
MS2 <- LipidMSdata2::msobjectDIAneg$peaklist$MS2[,c("mz", "RT", "int", "peakID")]
rawData <- rbind(LipidMSdata2::msobjectDIAneg$MS1, LipidMSdata2::msobjectDIAneg$MS2)

candidates <- findCandidates(MS1 = MS1, db = dbs$pgdb, ppm = 10,
rt = c(0, 2000), adducts = c("M-H"), rttol = 10, dbs = dbs,
rawData = rawData, coelCutoff = 0.8)
coelfrags <- coelutingFrags(candidates, MSMS, rttol = 10, rawData = rawData,
coelCutoff = 0.8)
classConf <- checkClass(candidates, coelfrags,
clfrags = c(227.0326, 209.022, 74.0359),
clrequisites = c(FALSE, FALSE, FALSE, FALSE),
ftype = c("F", "F", "NL"), ppm = 10, dbs = dbs)
sn1 <- chainFrags(coelfrags, chainfrags = c("lysopg_M-H"),
candidates = candidates, ppm = 10, dbs = dbs)
sn2 <- chainFrags(coelfrags, chainfrags = c("fa_M-H"), ppm = 10,
candidates = candidates, dbs = dbs)

chainsComb <- combineChains(candidates, nchains=2, sn1, sn2)
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
