% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NS07_LM.R
\name{FCI_NS07}
\alias{FCI_NS07}
\title{Rank estimation in fractionally cointegrated systems by Nielsen, Shimotsu (2007).}
\usage{
FCI_NS07(X, m, m1, mean_correct = c("mean", "init", "weighted", "none"),
  v_n = m^(-0.3))
}
\arguments{
\item{X}{data matrix.}

\item{m}{bandwith parameter specifying the number of Fourier frequencies
used for the estimation of G, usually \code{floor(1+T^delta)}, where 0<delta<1 and m1>m.}

\item{m1}{bandwith parameter specifying the number of Fourier frequencies
used for the memory estimation , usually \code{floor(1+T^delta1)}, where 0<delta1<1 and m1>m.}

\item{mean_correct}{specifies the form of mean correction in the memory estimation.}

\item{v_n}{bandwidth parameter. Nielsen and Shimotsu (2007) use m^(-0.3) in their simulation studies, which is the default value. m^(-b) mit 0<b<0.5 can be used.}
}
\description{
\code{FCI_NS07} Rank estimation in fractionally cointegrated systems by Nielsen, Shimotsu (2007).
 Returns estimated cointegrating rank, r=0,...,dim-1.
}
\examples{
T<-1000
series<-FI.sim(T=T, q=2, rho=0.4, d=c(0.1,0.4), B=rbind(c(1,-1),c(0,1)))
FCI_NS07(series, m1=floor(1+T^0.75), m=floor(1+T^0.65))
series<-FI.sim(T=T, q=2, rho=0.4, d=c(0.9,0.9))
FCI_NS07(series, m1=floor(1+T^0.75), m=floor(1+T^0.65))
}
\references{
Nielsen, M. 0. and Shimotsu, K. (2007): Determining the cointegrating rank in nonstationary fractional
systems by the exact local Whittle approach. Journal of Econometrics, Vol. 141, No. 2, pp. 574 - 596.
}
\author{
Christian Leschinski, Michelle Voges
}
