% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Analysis-class.R
\docType{class}
\name{RLum.Analysis-class}
\alias{RLum.Analysis-class}
\alias{show,RLum.Analysis-method}
\alias{set_RLum,RLum.Analysis-method}
\alias{get_RLum,RLum.Analysis-method}
\alias{structure_RLum,RLum.Analysis-method}
\alias{length_RLum,RLum.Analysis-method}
\alias{names_RLum,RLum.Analysis-method}
\alias{smooth_RLum,RLum.Analysis-method}
\title{Class \code{"RLum.Analysis"}}
\usage{
\S4method{show}{RLum.Analysis}(object)

\S4method{set_RLum}{RLum.Analysis}(class, originator, .uid, .pid,
  protocol = NA_character_, records = list(), info = list())

\S4method{get_RLum}{RLum.Analysis}(object, record.id = NULL,
  recordType = NULL, curveType = NULL, RLum.type = NULL,
  protocol = "UNKNOWN", get.index = NULL, drop = TRUE, recursive = TRUE,
  info.object = NULL, subset = NULL)

\S4method{structure_RLum}{RLum.Analysis}(object, fullExtent = FALSE)

\S4method{length_RLum}{RLum.Analysis}(object)

\S4method{names_RLum}{RLum.Analysis}(object)

\S4method{smooth_RLum}{RLum.Analysis}(object, ...)
}
\arguments{
\item{object}{\code{[show_RLum]}\code{[get_RLum]}\code{[names_RLum]}\code{[length_RLum]}
\code{[structure_RLum]}] an object of class \code{\linkS4class{RLum.Analysis}}
(\bold{required})}

\item{class}{[\code{set_RLum}] \code{\link{character}} (\bold{required}): name of the \code{RLum} class to be created}

\item{originator}{[\code{set_RLum}] \code{\link{character}} (automatic): contains the name
of the calling function (the function that produces this object); can be set manually.}

\item{.uid}{[\code{set_RLum}] \code{\link{character}} (automatic): sets an unique ID for this object
using the internal C++ function \code{.create_UID}.}

\item{.pid}{[\code{set_RLum}] \code{\link{character}} (with default): option to provide a parent id for nesting
at will.}

\item{protocol}{[\code{set_RLum}] \code{\link{character}} (optional): sets protocol type for
analysis object. Value may be used by subsequent analysis functions.}

\item{records}{[\code{set_RLum}] \code{\link{list}} (\bold{required}): list of \code{\linkS4class{RLum.Analysis}} objects}

\item{info}{[\code{set_RLum}] \code{\link{list}} (optional): a list containing additional
info data for the object

\bold{\code{set_RLum}}:\cr

Returns an \code{\linkS4class{RLum.Analysis}} object.}

\item{record.id}{[\code{get_RLum}] \code{\link{numeric}} or \code{\link{logical}} (optional): IDs of specific records.
If of type \code{logical} the entire id range is assuemd and \code{TRUE} and \code{FALSE} indicates the selection.}

\item{recordType}{[\code{get_RLum}] \code{\link{character}} (optional): record type (e.g., "OSL").
Can be also a vector, for multiple matching, e.g., \code{recordType = c("OSL", "IRSL")}}

\item{curveType}{[\code{get_RLum}] \code{\link{character}} (optional): curve
type (e.g. "predefined" or "measured")}

\item{RLum.type}{[\code{get_RLum}] \code{\link{character}} (optional): RLum object type.
Defaults to "RLum.Data.Curve" and "RLum.Data.Spectrum".}

\item{get.index}{[\code{get_RLum}] \code{\link{logical}} (optional): return a numeric
vector with the index of each element in the RLum.Analysis object.}

\item{drop}{[\code{get_RLum}] \code{\link{logical}} (with default): coerce to the next possible layer
(which are \code{RLum.Data}-objects), \code{drop = FALSE} keeps the original \code{RLum.Analysis}}

\item{recursive}{[\code{get_RLum}] \code{\link{logical}} (with default): if \code{TRUE} (the default)
and the result of the 'get_RLum' request is a single object this object will be unlisted, means
only the object itself and no list containing exactly one object is returned. Mostly this makes things
easier, however, if this method is used within a loop this might undesired.}

\item{info.object}{[\code{get_RLum}] \code{\link{character}} (optional): name of the wanted info
element}

\item{subset}{\code{\link{expression}} (optional): logical expression indicating elements or rows
to keep: missing values are taken as false. This argument takes precedence over all
other arguments, meaning they are not considered when subsetting the object.}

\item{fullExtent}{[structure_RLum] \code{\link{logical}} (with default): extents the returned \code{data.frame}
to its full extent, i.e. all info elements are part of the return as well. The default valule
is \code{FALSE} as the data frame might become rather big.}

\item{...}{further arguments passed to underlying methods}
}
\value{
\bold{\code{get_RLum}}:\cr

Returns: \cr
(1) \code{\link{list}} of \code{\linkS4class{RLum.Data}} objects or \cr
(2) Single \code{\linkS4class{RLum.Data}} object, if only one object is contained and
\code{recursive = FALSE} or\cr
(3) \code{\linkS4class{RLum.Analysis}} ojects for \code{drop = FALSE} \cr

\bold{\code{structure_RLum}}:\cr

Returns \code{\linkS4class{data.frame}} showing the structure.

\bold{\code{length_RLum}}\cr

Returns the number records in this object.

\bold{\code{names_RLum}}\cr

Returns the names of the record types (recordType) in this object.

\bold{\code{smooth_RLum}}\cr

Same object as input, after smoothing
}
\description{
Object class to represent analysis data for protocol analysis, i.e. all curves, spectra etc.
from one measurements. Objects from this class are produced, by e.g. \code{\link{read_XSYG2R}},
\code{\link{read_Daybreak2R}}
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Show structure of \code{RLum.Analysis} object

\item \code{set_RLum}: Construction method for \code{\linkS4class{RLum.Analysis}} objects.

\item \code{get_RLum}: Accessor method for RLum.Analysis object.

The slots record.id, recordType, curveType and RLum.type are optional to allow for records
limited by their id (list index number), their record type (e.g. recordType = "OSL")
or object type.

Example: curve type (e.g. curveType = "predefined" or curveType ="measured")

The selection of a specific RLum.type object superimposes the default selection.
Currently supported objects are: RLum.Data.Curve and RLum.Data.Spectrum

\item \code{structure_RLum}: Method to show the structure of an \code{\linkS4class{RLum.Analysis}} object.

\item \code{length_RLum}: Returns the length of the object, i.e., number of stored records.

\item \code{names_RLum}: Returns the names of the \code{\linkS4class{RLum.Data}} objects objects (same as shown with the show method)

\item \code{smooth_RLum}: Smoothing of \code{RLum.Data} objects contained in this \code{RLum.Analysis} object
\code{\link[zoo]{rollmean}} or \code{\link[zoo]{rollmedian}}.
In particular the internal function \code{.smoothing} is used.
}}

\section{Slots}{

\describe{
\item{\code{protocol}}{Object of class \code{\link{character}} describing the applied measurement protocol}

\item{\code{records}}{Object of class \code{\link{list}} containing objects of class \code{\linkS4class{RLum.Data}}}
}}

\note{
The method \code{\link{structure_RLum}} is currently just avaiblable for objects
containing \code{\linkS4class{RLum.Data.Curve}}.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{set_RLum("RLum.Analysis", ...)}.
}

\section{Class version}{
 0.4.8
}

\examples{

showClass("RLum.Analysis")

##set empty object
set_RLum(class = "RLum.Analysis")

###use example data
##load data
data(ExampleData.RLum.Analysis, envir = environment())

##show curves in object
get_RLum(IRSAR.RF.Data)

##show only the first object, but by keeping the object
get_RLum(IRSAR.RF.Data, record.id = 1, drop = FALSE)

}
\seealso{
\code{\link{Risoe.BINfileData2RLum.Analysis}},
\code{\linkS4class{Risoe.BINfileData}}, \code{\linkS4class{RLum}}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
} 

\section{How to cite}{
Kreutzer, S. (2017). RLum.Analysis-class(): Class 'RLum.Analysis'. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.1. https://CRAN.R-project.org/package=Luminescence
}

\keyword{classes}
\keyword{methods}
