% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_portableOSL.R
\name{analyse_portableOSL}
\alias{analyse_portableOSL}
\title{Analyse portable CW-OSL measurements}
\usage{
analyse_portableOSL(object, signal.integral, invert = FALSE,
  normalise = FALSE, plot = TRUE, ...)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis} (\strong{required}):
\code{RLum.Analysis} object produced by \link{read_PSL2R}.}

\item{signal.integral}{\link{vector} (\strong{required}):
A vector of two values specifying the lower and upper channel used to
calculate the OSL/IRSL signal. Can be provided in form of \code{c(1, 5)} or \code{1:5}.}

\item{invert}{\link{logical} (\emph{with default}):
\code{TRUE} to calculate and plot the data in reverse order.}

\item{normalise}{\link{logical} (\emph{with default}):
\code{TRUE} to normalise the OSL/IRSL signals by the mean of all corresponding
data curves.}

\item{plot}{\link{logical} (\emph{with default}):
enable/disable plot output}

\item{...}{currently not used.}
}
\value{
Returns an S4 \linkS4class{RLum.Results} object.
}
\description{
The function analyses CW-OSL curve data produced by a SUERC portable OSL reader and
produces a combined plot of OSL/IRSL signal intensities, OSL/IRSL depletion ratios
and the IRSL/OSL ratio.
}
\details{
This function only works with \code{RLum.Analysis} objects produced by \link{read_PSL2R}.
It further assumes (or rather requires) an equal amount of OSL and IRSL curves that
are pairwise combined for calculating the IRSL/OSL ratio. For calculating the depletion ratios
the cumulative signal of the last n channels (same number of channels as specified
by \code{signal.integral}) is divided by cumulative signal of the first n channels (\code{signal.integral}).
}
\section{Function version}{
 0.0.3 (2018-01-21 17:22:38)
}

\examples{

# (1) load example data set
data("ExampleData.portableOSL", envir = environment())

# (2) merge and plot all RLum.Analysis objects
merged <- merge_RLum(ExampleData.portableOSL)
plot_RLum(merged, combine = TRUE)
merged

# (3) analyse and plot
results <- analyse_portableOSL(merged, signal.integral = 1:5, invert = FALSE, normalise = TRUE)
get_RLum(results)



}
\seealso{
\linkS4class{RLum.Analysis}, \linkS4class{RLum.Data.Curve}
}
\author{
Christoph Burow, University of Cologne (Germany)
\cr R Luminescence Package Team} 

\section{How to cite}{
Burow, C. (2018). analyse_portableOSL(): Analyse portable CW-OSL measurements. Function version 0.0.3. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2018). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.8.4. https://CRAN.R-project.org/package=Luminescence
}

\keyword{datagen}
\keyword{plot}
