% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_DRTResults.R
\name{plot_DRTResults}
\alias{plot_DRTResults}
\title{Visualise dose recovery test results}
\usage{
plot_DRTResults(
  values,
  given.dose = NULL,
  error.range = 10,
  preheat,
  boxplot = FALSE,
  mtext,
  summary,
  summary.pos,
  legend,
  legend.pos,
  par.local = TRUE,
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{values}{\linkS4class{RLum.Results} or \link{data.frame} (\strong{required}):
input values containing at least De and De error. To plot
more than one data set in one figure, a \code{list} of the individual data
sets must be provided (e.g. \code{list(dataset.1, dataset.2)}).}

\item{given.dose}{\link{numeric} (\emph{optional}):
given dose used for the dose recovery test to normalise data.
If only one given dose is provided this given dose is valid for all input
data sets (i.e., \code{values} is a list).  Otherwise a given dose for each input
data set has to be provided (e.g., \code{given.dose = c(100,200)}).
If \code{given.dose} in \code{NULL} the values are plotted without normalisation
(might be useful for preheat plateau tests).
\strong{Note:} Unit has to be the same as from the input values (e.g., Seconds or
Gray).}

\item{error.range}{\link{numeric}:
symmetric error range in percent will be shown as dashed lines in the plot.
Set \code{error.range} to 0 to void plotting of error ranges.}

\item{preheat}{\link{numeric}:
optional vector of preheat temperatures to be used for grouping the De values.
If specified, the temperatures are assigned to the x-axis.}

\item{boxplot}{\link{logical}:
optionally plot values, that are grouped by preheat temperature as boxplots.
Only possible when \code{preheat} vector is specified.}

\item{mtext}{\link{character}:
additional text below the plot title.}

\item{summary}{\link{character} (\emph{optional}):
adds numerical output to the plot.  Can be one or more out of:
\itemize{
\item \code{"n"} (number of samples),
\item \code{"mean"} (mean De value),
\item \code{"weighted$mean"} (error-weighted mean),
\item \code{"median"} (median of the De values),
\item \code{"sd.rel"} (relative standard deviation in percent),
\item \code{"sd.abs"} (absolute standard deviation),
\item \code{"se.rel"} (relative standard error) and
\item \code{"se.abs"} (absolute standard error)
}

and all other measures returned by the function \link{calc_Statistics}.}

\item{summary.pos}{\link{numeric} or \link{character} (\emph{with default}):
optional position coordinates or keyword (e.g. \code{"topright"})
for the statistical summary. Alternatively, the keyword \code{"sub"} may be
specified to place the summary below the plot header. However, this latter
option in only possible if \code{mtext} is not used.}

\item{legend}{\link{character} vector (\emph{optional}):
legend content to be added to the plot.}

\item{legend.pos}{\link{numeric} or \link{character} (\emph{with default}):
optional position coordinates or keyword (e.g. \code{"topright"}) for the
legend to be plotted.}

\item{par.local}{\link{logical} (\emph{with default}):
use local graphical parameters for plotting, e.g. the plot is shown in one
column and one row. If \code{par.local = FALSE}, global parameters are inherited,
i.e. parameters provided via \code{par()} work}

\item{na.rm}{\link{logical}: indicating whether \code{NA} values are
removed before plotting from the input data set}

\item{...}{further arguments and graphical parameters passed to \link{plot}, supported are:
\code{xlab}, \code{ylab}, \code{xlim}, \code{ylim}, \code{main}, \code{cex}, \code{las} and `pch``}
}
\value{
A plot is returned.
}
\description{
The function provides a standardised plot output for dose recovery test
measurements.
}
\details{
Procedure to test the accuracy of a measurement protocol to reliably
determine the dose of a specific sample. Here, the natural signal is erased
and a known laboratory dose administered which is treated as unknown. Then
the De measurement is carried out and the degree of congruence between
administered and recovered dose is a measure of the protocol's accuracy for
this sample.\cr
In the plot the normalised De is shown on the y-axis, i.e. obtained De/Given Dose.
}
\note{
Further data and plot arguments can be added by using the appropriate R
commands.
}
\section{Function version}{
 0.1.13
}

\examples{

## read example data set and misapply them for this plot type
data(ExampleData.DeValues, envir = environment())

## plot values
plot_DRTResults(values = ExampleData.DeValues$BT998[7:11,],
given.dose = 2800, mtext = "Example data")

## plot values with legend
plot_DRTResults(values = ExampleData.DeValues$BT998[7:11,],
                given.dose = 2800,
                legend = "Test data set")

## create and plot two subsets with randomised values
x.1 <- ExampleData.DeValues$BT998[7:11,]
x.2 <- ExampleData.DeValues$BT998[7:11,] * c(runif(5, 0.9, 1.1), 1)

plot_DRTResults(values = list(x.1, x.2),
                given.dose = 2800)

## some more user-defined plot parameters
plot_DRTResults(values = list(x.1, x.2),
                given.dose = 2800,
                pch = c(2, 5),
                col = c("orange", "blue"),
                xlim = c(0, 8),
                ylim = c(0.85, 1.15),
                xlab = "Sample aliquot")

## plot the data with user-defined statistical measures as legend
plot_DRTResults(values = list(x.1, x.2),
                given.dose = 2800,
                summary = c("n", "mean.weighted", "sd"))

## plot the data with user-defined statistical measures as sub-header
plot_DRTResults(values = list(x.1, x.2),
                given.dose = 2800,
                summary = c("n", "mean.weighted", "sd"),
                summary.pos = "sub")

## plot the data grouped by preheat temperatures
plot_DRTResults(values = ExampleData.DeValues$BT998[7:11,],
                given.dose = 2800,
                preheat = c(200, 200, 200, 240, 240))
## read example data set and misapply them for this plot type
data(ExampleData.DeValues, envir = environment())

## plot values
plot_DRTResults(values = ExampleData.DeValues$BT998[7:11,],
                given.dose = 2800, mtext = "Example data")
## plot two data sets grouped by preheat temperatures
plot_DRTResults(values = list(x.1, x.2),
                given.dose = 2800,
                preheat = c(200, 200, 200, 240, 240))

## plot the data grouped by preheat temperatures as boxplots
plot_DRTResults(values = ExampleData.DeValues$BT998[7:11,],
                given.dose = 2800,
                preheat = c(200, 200, 200, 240, 240),
                boxplot = TRUE)

} 

\section{How to cite}{
Kreutzer, S., Dietze, M., 2021. plot_DRTResults(): Visualise dose recovery test results. Function version 0.1.13. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., 2021. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.13. https://CRAN.R-project.org/package=Luminescence
}

\references{
Wintle, A.G., Murray, A.S., 2006. A review of quartz optically
stimulated luminescence characteristics and their relevance in
single-aliquot regeneration dating protocols. Radiation Measurements, 41,
369-391.
}
\seealso{
\link{plot}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)\cr
Michael Dietze, GFZ Potsdam (Germany)
, RLum Developer Team}
\keyword{dplot}
