% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_XSYG2CSV.R
\name{convert_XSYG2CSV}
\alias{convert_XSYG2CSV}
\title{Export XSYG-file(s) to CSV-files}
\usage{
convert_XSYG2CSV(file, ...)
}
\arguments{
\item{file}{\link{character} (\strong{required}):
name of the XSYG-file to be converted to CSV-files}

\item{...}{further arguments that will be passed to the function
\link{read_XSYG2R} and \link{write_RLum2CSV}}
}
\value{
The function returns either a CSV-file (or many of them) or for the option \code{export = FALSE}
a list comprising objects of type \link{data.frame} and \link{matrix}
}
\description{
This function is a wrapper function around the functions \link{read_XSYG2R} and
\link{write_RLum2CSV} and it imports an XSYG-file and directly exports its content
to CSV-files. If nothing is set for the argument \code{path} (\link{write_RLum2CSV})
the input folder will become the output folder.
}
\section{Function version}{
 0.1.0
}

\examples{

##transform XSYG-file values to a list
data(ExampleData.XSYG, envir = environment())
convert_XSYG2CSV(OSL.SARMeasurement$Sequence.Object[1:10], export = FALSE)

\dontrun{
##select your BIN-file
file <- file.choose()

##convert
convert_XSYG2CSV(file)

}

}
\seealso{
\linkS4class{RLum.Analysis}, \linkS4class{RLum.Data}, \linkS4class{RLum.Results},
\link[utils:write.table]{utils::write.table}, \link{write_RLum2CSV}, \link{read_XSYG2R}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2019. convert_XSYG2CSV(): Export XSYG-file(s) to CSV-files. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., 2019. Luminescence: Comprehensive Luminescence Dating Data AnalysisR package version 0.9.4. https://CRAN.R-project.org/package=Luminescence
}

\keyword{IO}
