/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui;

import javax.swing.AbstractSpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExtendedSpinnerNumberModel
extends AbstractSpinnerModel {
    private Object extraItem = null;
    private SpinnerNumberModel model;
    private boolean showingExtraItem = false;

    public ExtendedSpinnerNumberModel() {
        this.model = new SpinnerNumberModel();
        this.model.addChangeListener(new MyChangeListener());
    }

    public ExtendedSpinnerNumberModel(Object value, double minimum, double maximum, double stepSize, Object extraItem) {
        this.model = new SpinnerNumberModel(minimum, minimum, maximum, stepSize);
        this.model.addChangeListener(new MyChangeListener());
        this.setExtraItem(extraItem);
        this.setValue(value);
    }

    public ExtendedSpinnerNumberModel(int value, int minimum, int maximum, int stepSize, Object extraItem) {
        this.model = new SpinnerNumberModel(value, minimum, maximum, stepSize);
        this.model.addChangeListener(new MyChangeListener());
        this.setExtraItem(extraItem);
    }

    public ExtendedSpinnerNumberModel(Number value, Comparable minimum, Comparable maximum, Number stepSize, Object extraItem) {
        this.model = new SpinnerNumberModel(value, minimum, maximum, stepSize);
        this.model.addChangeListener(new MyChangeListener());
        this.setExtraItem(extraItem);
    }

    public Object getExtraItem() {
        return this.extraItem;
    }

    public Object getNextValue() {
        Object result;
        if (this.showingExtraItem) {
            this.showingExtraItem = false;
            result = this.model.getValue();
            this.fireStateChanged();
        } else {
            result = this.model.getNextValue();
        }
        return result;
    }

    public Object getPreviousValue() {
        if (this.showingExtraItem) {
            return null;
        }
        Object result = this.model.getPreviousValue();
        if (result == null && !this.showingExtraItem) {
            this.showingExtraItem = true;
            this.fireStateChanged();
            return this.extraItem;
        }
        return result;
    }

    public Object getValue() {
        return this.showingExtraItem ? this.extraItem : this.model.getValue();
    }

    public void setExtraItem(Object extraItem) {
        this.extraItem = extraItem;
        if (this.showingExtraItem) {
            this.setValue(extraItem == null ? this.model.getValue() : extraItem);
        }
    }

    public void setValue(Object value) {
        boolean bl = this.showingExtraItem = value == this.extraItem;
        if (this.showingExtraItem) {
            this.model.setValue(this.model.getMinimum());
        } else {
            this.model.setValue(value);
        }
    }

    class MyChangeListener
    implements ChangeListener {
        MyChangeListener() {
        }

        public void stateChanged(ChangeEvent event) {
            ExtendedSpinnerNumberModel.this.fireStateChanged();
        }
    }
}

