% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_08_ADHOC_PLOT_2_PlotValues_Exp.R
\name{PlotValues.Exp}
\alias{PlotValues.Exp}
\title{Plot Gene Expression Values}
\usage{
PlotValues.Exp(
  MarvelObject,
  cell.type.columns,
  cell.type.variables,
  cell.type.labels,
  feature,
  maintitle = "gene_short_name",
  xlabels.size = 8
)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject} or \code{ComputePSI} function.}

\item{cell.type.columns}{List. To indicate which columns in the \code{MarvelObject$GenePheno} slot to refer to when filtering samples (cells) for analysis. Each item in the list defines the columns for each group to plot.}

\item{cell.type.variables}{List. To indicate which specific variables of the corresponding columns to keep the samples (cells). Each item in the list should be the same length as the corresponding item in the \code{cell.type.columns} list.}

\item{cell.type.labels}{Character string. To indicate the cell group labels on the x-axis. Should be same length as the number of items in \code{cell.type.columns} and \code{cell.type.variables} lists.}

\item{feature}{Character string. \code{gene_id} for plotting. Should match \code{gene_id} column of \code{MarvelObject$GeneFeature} slot.}

\item{maintitle}{Character string. Column to use as plot main title as per \code{MarvelObject$GeneFeature}. Default is \code{"gene_short_name"} column.}

\item{xlabels.size}{Numeric value. Size of x-axis labels as per \code{ggplot2} function. Default is 8.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{MarvelObject$adhocPlot$Exp}.
}
\description{
\code{PlotValues.Exp} plots gene expression values across different groups of cells.
}
\details{
This function plots gene expression values across different groups of cells. Boxplot is used for gene expression values.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Define event to plot
gene_id <- marvel$DE$PSI$Table$gene_id[1]

# Run example
marvel <- PlotValues.Exp(MarvelObject=marvel,
                         cell.type.columns=list(c("cell.type"), c("cell.type")),
                         cell.type.variables=list(list("iPSC"), list("Endoderm")),
                         cell.type.labels=c("iPSC", "Endoderm"),
                         feature=gene_id,
                         xlabels.size=9
                         )

# Check output
marvel$adhocPlot$Exp
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
