% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_02_DETECT_EVENTS_2_2_AFE_NegStrand.R
\name{DetectEvents.AFE.NegStrand}
\alias{DetectEvents.AFE.NegStrand}
\title{Detect alternative first exons on negative strand}
\usage{
DetectEvents.AFE.NegStrand(
  MarvelObject,
  parsed.gtf = NULL,
  min.cells = 50,
  min.expr = 1,
  track.progress = FALSE
)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject} function.}

\item{parsed.gtf}{Data frame. GTF file with the gene_id parsed. Generated from the \code{DetectEvents.AFE} function.}

\item{min.cells}{Numeric value. The minimum number of cells in which the gene is expressed for the gene to included for splicing event detected and quantification. To be used in conjunction with \code{min.expr} argument. Default value is \code{50}.}

\item{min.expr}{Numeric value. The minimum expression value for the gene to be considered to be expressed in a cell. Default value is \code{1}.}

\item{track.progress}{Logical. If set to \code{TRUE}, progress bar will appear to track the progress of the rate-limiting step of this function, which is the extraction of the final exon-exon junctions. Default value is \code{FALSE}.}
}
\value{
An object of class S3 with new slot \code{MarvelObject$SpliceFeature$AFE.NegStrand}.
}
\description{
Detects alternative first exons, specifically for genes transcribed on the negative strand of the DNA.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- DetectEvents.AFE.NegStrand(MarvelObject=marvel.demo,
                                          parsed.gtf=NULL,
                                          min.cells=5,
                                          min.expr=1,
                                          track.progress=FALSE
                                          )
}
