% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimilarityNetworkFusion.r
\name{SimilarityNetworkFusion}
\alias{SimilarityNetworkFusion}
\title{Similarity network fusion (SNF)}
\usage{
SimilarityNetworkFusion(
  Files = NULL,
  NNeighbors,
  Sigma,
  NClusters,
  CLabels = NULL,
  RLabels = NULL,
  Niterations
)
}
\arguments{
\item{Files}{A list of data frames created using the ReadSNFData function or matrices.}

\item{NNeighbors}{The number of nearest neighbors.}

\item{Sigma}{The variance for local model.}

\item{NClusters}{The number of clusters.}

\item{CLabels}{A string vector to name the clusters. Optional.}

\item{RLabels}{The actual label of samples to calculate the Normalized Mutual Information (NMI) score. Optional.}

\item{Niterations}{The number of iterations for the diffusion process.}
}
\value{
Factor
}
\description{
A function to perform SNF function (from SNFtool package) and output clusters.
}
\examples{
data(RLabels) # Real labels
data(Data2) # Methylation
data(Data3) # Gene expression
snf <- SimilarityNetworkFusion(Files = list(Data2, Data3),
                               NNeighbors  = 13,
                               Sigma = 0.75,
                               NClusters = 4,
                               CLabels = c("Group4", "SHH", "WNT", "Group3"),
                               RLabels = RLabels,
                               Niterations = 10)
snf
}
