% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.functions.R
\name{plot.mb.rank}
\alias{plot.mb.rank}
\title{Plot histograms of rankings from MBNMA models}
\usage{
\method{plot}{mb.rank}(x, params = NULL, treat.labs = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{"mb.rank"} generated by \code{rank.mbnma()}}

\item{params}{A character vector containing any model parameters monitored
in \code{mbnma} for which ranking is desired (e.g. \code{"beta.1"}, \code{"d.emax"}).
Parameters must vary by treatment for ranking to be possible. Can include
\code{"auc"} (see details).}

\item{treat.labs}{A vector of treatment labels in the same order as treatment codes.
Easiest to use treatment labels stored by \code{mb.network()}}

\item{...}{Arguments to be sent to \code{ggplot::geom_bar()}}
}
\value{
A series of histograms that show rankings for each treatment/agent/prediction, with a
separate panel for each parameter
The object returned is a list containing a separate element for each parameter in \code{params}
which is an object of class \code{c("gg", "ggplot")}.
}
\description{
Plot histograms of rankings from MBNMA models
}
\examples{
\donttest{
# Create an mb.network object from a dataset
network <- mb.network(osteopain)

# Run an MBNMA model with an Emax time-course
emax <- mb.emax(network,
  emax=list(pool="rel", method="common"),
  et50=list(pool="arm", method="common"),
  positive.scale=TRUE)

# Calculate treatment rankings
ranks <- rank(emax,
  param=c("auc", "d.emax", "beta.et50"),
  int.range=c(0,15),
  treats=c(1:10), n.iter=500)

# Plot histograms for ranking by AUC
plot(ranks, param="auc")

# Plot histograms for ranking by d.emax
plot(ranks, param="d.emax")
}

}
