% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationary_mle.R
\name{stationary_mle}
\alias{stationary_mle}
\title{MLE for stationary distribution of discrete MCMC variables}
\usage{
stationary_mle(z, N, labels, method = "rev", abstol = 1e-05, maxit = 1e+05)
}
\arguments{
\item{z}{MCMC output for the discrete indicator variable with numerical,
character, or factor labels (can also be a \code{\link[coda]{mcmc.list}}
or a matrix with one MCMC chain per column).}

\item{N}{the observed \code{\link{transitions}} matrix (if supplied, \code{z} is ignored).
A quadratic matrix with sampled transition frequencies
(\code{N[i,j]} = number of switches from \code{z[t]=i} to \code{z[t+1]=j}).}

\item{labels}{optional: vector of labels for complete set of models
(e.g., models not sampled in the chain \code{z}). If \code{epsilon=0},
this does not affect inferences due to the improper Dirichlet(0,..,0) prior.}

\item{method}{Different types of MLEs:
\itemize{
  \item \code{"iid"}: Assumes i.i.d. sampling of the model indicator variable \code{z} and estimates \eqn{\pi} as the relative frequencies each model was sampled.
  \item \code{"rev"}: Estimate stationary distribution under the constraint that the transition matrix is reversible (i.e., fulfills detailed balance) based on the iterative fixed-point algorithm proposed by Trendelkamp-Schroer et al. (2015)
  \item \code{"eigen"}: Computes the first left-eigenvector (normalized to sum to 1) of the sampled transition matrix
 }}

\item{abstol}{absolute convergence tolerance (only for \code{method = "rev"})}

\item{maxit}{maximum number of iterations (only for \code{method = "rev"})}
}
\value{
a vector with posterior model probability estimates
}
\description{
Maximum-likelihood estimation of stationary distribution \eqn{\pi} based on (a) a sampled trajectory \eqn{z} of a model-indicator variable or (b) a sampled transition count matrix \eqn{N}.
}
\details{
The estimates are implemented mainly for comparison with the Bayesian sampling approach implemented in \code{\link{stationary}}, which quantify estimation uncertainty (i.e., posterior SD) of the posterior model probability estimates.
}
\examples{
P <- matrix(c(.1,.5,.4,
              0,.5,.5,
              .9,.1,0), ncol = 3, byrow=TRUE)
z <- rmarkov(1000, P)
stationary_mle(z)

# input: transition frequency
tab <- transitions(z)
stationary_mle(N = tab)
}
\references{
Trendelkamp-Schroer, B., Wu, H., Paul, F., & Noé, F. (2015). Estimation and uncertainty of reversible Markov models. The Journal of Chemical Physics, 143(17), 174101. \url{https://doi.org/10.1063/1.4934536}
}
\seealso{
\code{\link{stationary}}
}
