% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compileModel.R
\name{compileModel}
\alias{compileModel}
\title{Function to translate and compile MCSim model specification text}
\usage{
compileModel(model_file, c_file, dll_name, dll_file, hash_file = NULL)
}
\arguments{
\item{model_file}{Name of an MCSim model specification file.}

\item{c_file}{Name of a C source code file to be created by compiling the MCSim model specification file.}

\item{dll_name}{Name of a DLL or SO file without the extension (".dll" or ".so").}

\item{dll_file}{Name of the same DLL or SO file with the appropriate extension (".dll" or ".so").}

\item{hash_file}{Name of a file containing a hash key for determining if \code{model_file} has changed since the previous translation and compilation.}
}
\value{
No return value. Creates files and saves them in locations specified by function arguments.
}
\description{
This function translates MCSim model specification text to C and then
compiles the resulting C file to create a dynamic link library (DLL) file (on
Windows) or a shared object (SO) file (on Unix).
}
