% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmpMDPWriter.R
\name{hmpMDPWriter}
\alias{hmpMDPWriter}
\title{Function for writing an HMDP model to a hmp file (XML). The function define
sub-functions which can be used to define an HMDP model stored in a hmp file.}
\usage{
hmpMDPWriter(
  file = "r.hmp",
  rate = 0.1,
  rateBase = 1,
  precision = 1e-05,
  desc = "HMP file created using hmpMDPWriter in R",
  getLog = TRUE
)
}
\arguments{
\item{file}{The name of the file storing the model (e.g. \code{r.hmp}).}

\item{rate}{The interest rate (used if consider discounting).}

\item{rateBase}{The time where the \code{rate} is taken over, e.g. if the \code{rate} is 0.1 and \code{rateBase} is 365 days
then we have an interest rate of 10 percent over the year.}

\item{precision}{The precision used when checking if probabilities sum to one.}

\item{desc}{Description of the model.}

\item{getLog}{Output log text.}
}
\value{
A list of functions.
}
\description{
HMP files are in XML format and human readable using e.g. a text editor.
HMP files are not suitable for storing large HMDP models since text files are very
verbose. Moreover, approximation of the weights and probabilities may occur since
the parser writing the hmp file may no output all digits. If you consider large
models then use the binary file format instead.
}
\details{
The functions which can be used are:\itemize{
\item{\code{setWeights(labels, duration)}: }{Set the labels of the weights used in the actions.
\code{labels} is a vector of label names, \code{duration} A number defining which label
that corresponds to duration/time, e.g. if the first entry in labels is time then \code{duration = 1}.
The function must be called before starting building the model.}
\item{\code{process()}: }{Starts a (sub)process.}
\item{\code{endProcess()}: }{Ends a (sub)process.}
\item{\code{stage(label=NULL)}: }{Starts a stage.}
\item{\code{endStage()}: }{Ends a (sub)process.}
\item{\code{state(label=NULL)}: }{Starts a state. Returns the states index number \code{sIdx}.}
\item{\code{endState()}: }{Ends a stage.}
\item{\code{action(label=NULL, weights, prob, statesNext=NULL)}: }{Starts an action.
Parameter \code{weights} must be a vector of action weights,
\code{prob} must contain triples of \verb{(scope, idx, pr)}.
The \code{scope} can be 3 values:
* 0: A transition to the next stage in the father process,
* 1: A transition to next stage in the current process,
* 2: A transition to a child process (stage zero in the child process).
\code{idx} in the pair denote the index of the state at the stage considered, e.g. if \code{scope = 1}
and \code{idx = 2} we consider state number 3 at next stage in the current process
(number from zero). Note \code{scope = 3} is not supported in the \code{hmp} file format!
\code{statesNext} is the number of states in the next stage of the process
(only needed if have a transition to the father).}
\item{\code{endAction()}: }{Ends an action.}
\item{\code{closeWriter()}: }{Close the writer. Must be called when the model description has finished.}}
}
\note{
Note all indexes are starting from zero (C/C++ style).
}
\examples{
## Use temp dir
wd <- setwd(tempdir())

## Create a small HMDP with two levels
w<-hmpMDPWriter()
w$setWeights(c("Duration","Net reward","Items"), duration=1)
w$process()
  w$stage()
   w$state(label="M0")
     w$action(label="A0",weights=c(0,0,0),prob=c(2,0,1))
      w$process()
        w$stage()
         w$state(label="D")
           w$action(label="A0",weights=c(0,0,1),prob=c(1,0,0.5,1,1,0.5))
           w$endAction()
         w$endState()
        w$endStage()
        w$stage()
         w$state(label="C0")
           w$action(label="A0",weights=c(0,0,0),prob=c(1,0,1))
           w$endAction()
           w$action(label="A1",weights=c(1,2,1),prob=c(1,0,0.5,1,1,0.5))
           w$endAction()
         w$endState()
         w$state(label="C1")
           w$action(label="A0",weights=c(0,0,0),prob=c(1,0,1))
           w$endAction()
           w$action(label="A1",weights=c(1,2,1),prob=c(1,0,0.5,1,1,0.5))
           w$endAction()
         w$endState()
        w$endStage()
        w$stage()
         w$state(label="C0")
           w$action(label="A0",weights=c(1,4,0),prob=c(0,0,1), statesNext=0)
           w$endAction()
         w$endState()
         w$state(label="C1")
           w$action(label="A0",weights=c(1,4,0),prob=c(0,0,1), statesNext=0)
           w$endAction()
         w$endState()
        w$endStage()
      w$endProcess()
     w$endAction()
     w$action(label="A1",weights=c(0,0,0),prob=c(2,0,1))
      w$process()
        w$stage()
         w$state(label="D")
           w$action(label="A0",weights=c(0,0,1),prob=c(1,0,1))
           w$endAction()
         w$endState()
        w$endStage()
        w$stage()
         w$state(label="C0")
           w$action(label="A0",weights=c(0,0,0),prob=c(1,0,1))
           w$endAction()
           w$action(label="A1",weights=c(1,2,1),prob=c(1,0,0.5,1,1,0.5))
           w$endAction()
         w$endState()
        w$endStage()
        w$stage()
         w$state(label="C0")
           w$action(label="A0",weights=c(1,4,0),prob=c(0,0,1), statesNext=0)
           w$endAction()
         w$endState()
         w$state(label="C1")
           w$action(label="A0",weights=c(1,4,0),prob=c(0,0,1), statesNext=0)
           w$endAction()
           w$action(label="A1",weights=c(0,10,5),prob=c(0,0,0.5,0,1,0.5), statesNext=0)
           w$endAction()
         w$endState()
        w$endStage()
      w$endProcess()
     w$endAction()
   w$endState()
   w$state(label="M1")
     w$action(label="A0",weights=c(0,0,0),prob=c(2,0,1))
      w$process()
        w$stage()
         w$state(label="D")
           w$action(label="A0",weights=c(0,0,1),prob=c(1,0,0.5,1,1,0.5))
           w$endAction()
         w$endState()
        w$endStage()
        w$stage()
         w$state(label="C0")
           w$action(label="A0",weights=c(0,0,0),prob=c(1,0,1))
           w$endAction()
         w$endState()
         w$state(label="C1")
           w$action(label="A0",weights=c(0,0,0),prob=c(1,0,1))
           w$endAction()
         w$endState()
        w$endStage()
        w$stage()
         w$state(label="C0")
           w$action(label="A0",weights=c(1,4,0),prob=c(0,0,1), statesNext=0)
           w$endAction()
         w$endState()
         w$state(label="C1")
           w$action(label="A0",weights=c(1,4,0),prob=c(0,0,1), statesNext=0)
           w$endAction()
         w$endState()
        w$endStage()
      w$endProcess()
     w$endAction()
   w$endState()
  w$endStage()
w$endProcess()
w$closeWriter()

## Have a look at the hmp file
cat(readr::read_file("r.hmp"))

## Reset working dir
setwd(wd)
}
