% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{calc.maps.pc}
\alias{calc.maps.pc}
\title{Estimate marker positions using Principal Curves}
\usage{
calc.maps.pc(fname, spar = NULL, n = NULL, ndim = 2, weightfn = "lod2",
  mapfn = "haldane")
}
\arguments{
\item{fname}{Character string the name of the file of recombination fractions 
and scores it should not contain any suffices (the file should be a .txt file 
as described below).}

\item{spar}{Integer - the smoothing parameter for the principal curve. If 
NULL this will be done using leave one out cross validation.}

\item{n}{Vector of integers or character strings containing markers to be 
omitted from the analysis.}

\item{ndim}{Number of dimensions in which to perform the wMDS and fit the 
curve - can be 2 or 3.}

\item{weightfn}{Character string specifying the values to use for the weight 
matrix in the MDS \code{'lod2'} or \code{'lod'}.}

\item{mapfn}{Character string specifying the map function to use on the 
recombination fractions \code{'haldane'} is default, \code{'kosambi'} or \code{'none'}.}
}
\value{
A list (S3 class pcmap or pcmap3d depending on ndim) with the following elements:
\item{smacofsym}{The unconstrained wMDS results.}
\item{pc}{The results from the principal curve fit.}
\item{distmap}{A symmetric matrix of pairwise distances between markers where 
the columns are in the estimated order.}
\item{lodmap}{A symmetric matrix of lod scores associated with the distances 
in distmap.}
\item{locimap}{A data frame of the markers containing the name of each marker, 
the number in the configuration plot if that is being used, the position of each 
marker in order of increasing distance and the nearest neighbour fit of the marker.}
\item{length}{Integer giving the total length of the segment.}
\item{removed}{A vector of the names of markers removed from the analysis.}
\item{locikey}{A data frame showing the number associated with each marker name 
for interpreting the wMDS configuration plots.}
\item{meannnfit}{The mean across all markers of the nearest neighbour fits.}
}
\description{
Reads a text file of pairwise recombination fractions and LOD scores, reduces 
to 2 or 3 dimensions using wMDS and projects onto a single dimension using 
principal curves to estimate marker positions.
}
\details{
Reads a file of the form described below and casts the data into matrices of 
pairwise recombination fractions and weights determined by the \code{weightfn} 
parameter (\code{LOD} or \code{LOD^2^}) calculates a distance matrix from the map function. 
Haldane is the default map function, none just uses recombination fractions 
and the other alternative is Kosambi (see \code{\link{dmap}} for details). 

Performs both an weighted MDS on the distance matrix using \code{\link[smacof]{smacofSym}} and 
\code{\link[smacof]{smacofSphere}} (\cite{de Leeuw & Mair 2009}) and fits a 
principal curve to map this to an interval (\code{\link[princurve]{principal.curve}} for details).

File names should be of the form \code{fname.txt} and it is assumed that they are in 
a tab or space separated file of the format displayed below. The first entry on 
the first row is the number of markers to be analysed. Underneath this is a 
table in which the first two columns contain marker names, the third column 
contains the pairwise recombination fractions between the markers and the 
fourth column the associated lod score.  Note that marker names in the first 
column vary more slowly than in the second column. Missing recombination pairs 
are acceptable. Recombination fractions greater than 0.499999 are set to that 
value.

\tabular{llll}{
\cr
\code{nmarkers} \tab \tab \tab \cr
\code{marker_1} \tab \code{marker_2} \tab \code{recombination fraction} \tab \code{LOD}\cr
\code{1} \tab \code{2} \tab \code{.} \tab \code{.} \cr
\code{1} \tab \code{3} \tab \code{.} \tab \code{.} \cr
\code{1} \tab \code{4} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{2} \tab \code{3} \tab \code{.} \tab \code{.} \cr
\code{2} \tab \code{4} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
}
}
\examples{
map<-calc.maps.pc(system.file("extdata", "lgV.txt", package="MDSMap"),
ndim=2,weightfn='lod2',mapfn='kosambi')
plot(map)
}
\references{
\cite{de Leeuw J, Mair P (2009) Multidimensional scaling using majorization: SMACOF in R. J Stat Softw 31: 1-30} \url{http://www.jstatsoft.org/v31/i03/}

\cite{Hastie T, Weingessel A (2013) princurve: Fits a Principal Curve in Arbitrary Dimension. ) R package version 1.1-12.} \url{https://CRAN.R-project.org/package=princurve}
}
\seealso{
\code{\link{calc.maps.sphere}}, \code{\link{calc.pair.rf.lod}}, \code{\link[smacof]{smacofSym}}, \code{\link[smacof]{smacofSphere}}, \code{\link{map.to.interval}}, \code{\link{dmap}}
}
