% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcQR.R
\name{fcQR}
\alias{fcQR}
\title{Solve quantile regression models with functional covariate(s).}
\usage{
fcQR(
  Y,
  FC,
  Z,
  formula.Z,
  tau = 0.5,
  basis.type = c("Fourier", "Bspline"),
  basis.order = 6L,
  bs_degree = 3
)
}
\arguments{
\item{Y}{Response variable, can be an atomic vector, a one-column matrix or data frame,
recommended form is a one-column data frame with column name}

\item{FC}{Functional covariate(s),
can be a "functional_variable" object or a matrix or a data frame or a list of these object(s)}

\item{Z}{Scalar covariate(s), can be NULL or not input (when there's no scalar covariate),
an atomic vector (when only one scalar covariate), a matrix or data frame,
recommended form is a data frame with column name(s)}

\item{formula.Z}{A formula without the response variable, contains only scalar covariate(s).
If not assigned, include all scalar covariates and intercept term.}

\item{tau}{Quantile \eqn{\tau\in(0,1)}, default is 0.5. See \code{\link[quantreg]{rq}}.}

\item{basis.type}{Type of funtion basis.
Can only be assigned as one type even if there is more than one functional covariates.
Available options: 'Fourier' or 'Bspline', represent Fourier basis and b-spline basis respectively.
For the detailed form for Fourier and b-splines basis,
see \code{\link{fourier_basis_expansion}} and \code{\link{bspline_basis_expansion}}.}

\item{basis.order}{Indicate number of the function basis.
When using Fourier basis \eqn{\frac{1}{2},\sin k t, \cos k t, k = 1,\dots,K},
basis.order is the number \eqn{K}.
When using b-splines basis \eqn{\{B_{i,p}(x)\}_{i=-p}^{k}},
basis.order is the number of splines, equal to \eqn{k+p+1}.
(same as arguement \code{df} in \code{\link[splines]{bs}}.)
May set a individual number for each functional covariate.
When the element of this argument is less than the number of functional covariates,
it will be used recursively.}

\item{bs_degree}{Degree of the piecewise polynomials if use b-splines basis, default is 3.
See \code{degree} in \code{\link[splines]{bs}}.}
}
\value{
fcQR returns an object of class "fcQR".
    It is a list that contains the following elements.
    \item{regression_result}{Result of the regression.}
    \item{FC.BasisCoefficient}{A list of Fourier_series or bspline_series object(s),
    represents the functional linear coefficient(s) of the functional covariates.}
    \item{function.basis.type}{Type of funtion basis used.}
    \item{basis.order}{Same as in the arguemnets.}
    \item{data}{Original data.}
    \item{bs_degree}{Degree of the splines, returned only if b-splines basis is used.}
}
\description{
Fit a quantile regression models below
\deqn{Q_{Y_i|X_i,Z_i}(\tau) = \sum_{l=1}^L\int_\Omega \beta_l(\tau,t) X_{li}(t) dt + (1,Z_i^T)\gamma}
where \eqn{Q_{Y_i}(\tau) = F_{Y_i|X_i,Z_i}^{-1}(\tau)} is the
\eqn{\tau}-th quantile of \eqn{Y_i} given \eqn{X_i(t)} and \eqn{Z_i},
\eqn{\tau\in(0,1)}.
\cr Model allows one or multiple functional covariate(s) as fixed effect(s),
and zero, one, or multiple scalar-valued covariate(s).
}
\examples{
data(MECfda.data.sim.0.0)
res = fcQR(FC = MECfda.data.sim.0.0$FC, Y=MECfda.data.sim.0.0$Y, Z=MECfda.data.sim.0.0$Z,
           basis.order = 5, basis.type = c('Bspline'))

}
\author{
Heyang Ji
}
