% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ME.fcQR_IV.SIMEX.R
\name{ME.fcQR_IV.SIMEX}
\alias{ME.fcQR_IV.SIMEX}
\title{Bias correction method of applying quantile linear regression to dataset
with one functional covariate with measurement error using instrumental variable.}
\usage{
ME.fcQR_IV.SIMEX(
  data.Y,
  data.W,
  data.Z,
  data.M,
  tau = 0.5,
  t_interval = c(0, 1),
  t_points = NULL,
  formula.Z,
  basis.type = c("Fourier", "Bspline"),
  basis.order = NULL,
  bs_degree = 3
)
}
\arguments{
\item{data.Y}{Response variable, can be an atomic vector, a one-column matrix or data frame,
recommended form is a one-column data frame with column name.}

\item{data.W}{A dataframe or matrix, represents \eqn{W}, the measurement of \eqn{X}.
Each row represents a subject. Each column represent a measurement (time) point.}

\item{data.Z}{Scalar covariate(s),
can be not input or \code{NULL} (when there's no scalar covariate),
an atomic vector (when only one scalar covariate), a matrix or data frame,
recommended form is a data frame with column name(s).}

\item{data.M}{A dataframe or matrix, represents \eqn{M},
the instrumental variable. Each row represents a subject.
Each column represent a measurement (time) point.}

\item{tau}{Quantile \eqn{\tau\in(0,1)}, default is 0.5.}

\item{t_interval}{A 2-element vector, represents an interval,
means the domain of the functional covariate. Default is c(0,1), represent interval \eqn{[0,1]}.}

\item{t_points}{Sequence of the measurement (time) points, default is \code{NULL}.}

\item{formula.Z}{A formula without the response variable,
contains only scalar covariate(s), no random effects. If not assigned,
include all scalar covariates and intercept term.}

\item{basis.type}{Type of funtion basis.
Can only be assigned as one type even if there is more than one functional covariates.
Available options: 'Fourier' or 'Bspline', represent Fourier basis and b-spline basis respectively.
For the detailed form for Fourier and b-splines basis,
see \code{\link{fourier_basis_expansion}} and \code{\link{bspline_basis_expansion}}.}

\item{basis.order}{Indicate number of the function basis.
When using Fourier basis \eqn{\frac{1}{2},\sin k t, \cos k t, k = 1,\dots,K},
basis.order is the number \eqn{K}.
When using b-splines basis \eqn{\{B_{i,p}(x)\}_{i=-p}^{k}},
basis.order is the number of splines, equal to \eqn{k+p+1}.
(same as arguement \code{df} in \code{\link[splines]{bs}}.)
May set a individual number for each functional covariate.
When the element of this argument is less than the number of functional covariates,
it will be used recursively.}

\item{bs_degree}{Degree of the piecewise polynomials if use b-splines basis,
default is 3. See \code{degree} in \code{\link[splines]{bs}}.}
}
\value{
Returns a ME.fcQR_IV.SIMEX class object.
It is a list that contains the following elements.
\item{coef.X}{A Fourier_series or bspline_series object,
represents the functional coefficient parameter of the functional covariate.}
\item{coef.Z}{The estimate of the linear coefficients of the scalar covariates.}
\item{coef.all}{Original estimate of linear coefficients.}
\item{function.basis.type}{Type of funtion basis used.}
\item{basis.order}{Same as in the input arguements.}
\item{t_interval}{A 2-element vector, represents an interval,
means the domain of the functional covariate.}
\item{t_points}{Sequence of the measurement (time) points.}
\item{formula}{Regression model.}
\item{formula.Z}{formula object contains only the scalar covariate(s).}
\item{zlevels}{levels of the non-continuous scalar covariate(s). }
}
\description{
Perform a two-stage strategy to correct the measurement error of
a function-valued covariate and then fit a linear quantile regression model.
In the first stage, an instrumental variable is used to estimate
the covariance matrix associated with the measurement error.
In the second stage, simulation extrapolation (SIMEX) is used to correct for
measurement error in the function-valued covariate. \cr
See detailed model in the reference.
}
\examples{
data(MECfda.data.sim.0.2)
\donttest{
res = ME.fcQR_IV.SIMEX(data.Y = MECfda.data.sim.0.2$Y,
                       data.W = MECfda.data.sim.0.2$W,
                       data.Z = MECfda.data.sim.0.2$Z,
                       data.M = MECfda.data.sim.0.2$M,
                       tau = 0.5,
                       basis.type = 'Bspline')
}
}
\references{
Tekwe, Carmen D., et al.
"Estimation of sparse functional quantile regression with measurement error: a SIMEX approach."
Biostatistics 23.4 (2022): 1218-1241.
}
