% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.mcnemar.test.R
\name{power_mcnemar_test}
\alias{power_mcnemar_test}
\title{Power Calculations for Exact and Asymptotic McNemar Test in a 2 by 2 table}
\usage{
power_mcnemar_test(n = NULL, paid = NULL, psi = NULL, sig.level = 0.05,
  power = NULL, alternative = c("two.sided", "one.sided"),
  method = c("normal", "exact", "cond.exact"))
}
\arguments{
\item{n}{Number of observations (number of pairs)}

\item{paid}{The probability that a case patient is not exposed and that the
corresponding control patient was exposed (specifying p_12 in the 2 x 2 table).}

\item{psi}{The relative probability that a control patient is not exposed and that the corresponding case patient was exposed compared to the probability that a case patient is not exposed and that the corresponding control patient was exposed (p12 / p21 in the 2x2 table). Also called the discordant proportion ratio}

\item{sig.level}{Significance level (Type I error probability)}

\item{power}{Power of test (1 minus Type II error probability)}

\item{alternative}{One- or two-sided test}

\item{method}{Power calculations based on exact or asymptotic test. The default (normal) corresponds to an approximative test, "exact" is the unconditional exact test, while "cond.exact" is a conditional exact test (given fixed n).}
}
\value{
Object of class \code{power.htest}, a list of the arguments
(including the computed one) augmented with method and note elements.
}
\description{
Compute power of test, or determine parameters to obtain target power for
matched case-control studies.
}
\details{
If psi is less than 1 then the two probabilities p_12 and p_21 are reversed.
}
\note{
\code{uniroot} is used to solve power equation for unknowns, so you
may see errors from it, notably about inability to bracket the root when
invalid arguments are given.
}
\examples{

# Assume that pi_21 is 0.125 and we wish to detect an OR of 2.
# This implies that pi_12=0.25, and with alpha=0.05, and a power of 90\% you get
power_mcnemar_test(n=NULL, paid=.125, psi=2, power=.9)

power_mcnemar_test(n=NULL, paid=.1, psi=2, power=.8, method="normal")
power_mcnemar_test(n=NULL, paid=.1, psi=2, power=.8)



}
\references{
Duffy, S (1984). Asymptotic and Exact Power for the McNemar Test
and its Analogue with R Controls per Case

Fagerland MW, Lydersen S, Laake P. (2013) The McNemar test for binary matched-pairs data: mid-p and asymptotic
are better than exact conditional. BMC Medical Research Methodology.
}
\seealso{
\code{\link{mcnemar.test}}
}
\author{
Claus Ekstrom \email{claus@rprimer.dk}
}
\keyword{htest}
