% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equilibrium-epiImperial.R
\name{equilibrium_SEI_Imperial}
\alias{equilibrium_SEI_Imperial}
\title{Calculate Equilibrium for Mosquito SEI - Human Imperial Model}
\usage{
equilibrium_SEI_Imperial(
  params,
  node_list = "b",
  NF = NULL,
  phi = 0.5,
  NH = NULL,
  log_dd = TRUE,
  spn_P,
  pop_ratio_Aq = NULL,
  pop_ratio_F = NULL,
  pop_ratio_M = NULL,
  pop_ratio_H = 1,
  cube
)
}
\arguments{
\item{params}{a named list of parameters (see details)}

\item{node_list}{list of geospatial nodes}

\item{NF}{number of female mosquitoes}

\item{phi}{sex ratio of mosquitoes at emergence}

\item{NH}{vector of humans at equilibrium}

\item{log_dd}{Boolean: TRUE implies logistic density dependence, FALSE implies Lotka-Volterra model}

\item{spn_P}{the set of places (P) (see details)}

\item{pop_ratio_Aq}{May be empty; if not, a named vector or matrix. (see details)}

\item{pop_ratio_F}{May be empty; if not, a named vector or matrix. (see details)}

\item{pop_ratio_M}{May be empty; if not, a named vector or matrix. (see details)}

\item{pop_ratio_H}{Prevalence in human-only nodes}

\item{cube}{an inheritance cube from the \code{MGDrivE} package (e.g. \code{\link[MGDrivE]{cubeMendelian}})}
}
\value{
a vector of the equilibrium number of females in each SEI stage
}
\description{
In decoupled sampling, human states are handled separately from mosquito states.
The function \code{equilibrium_Imperial_decoupled_human} calculates the distribution of humans
at equilibrium required for the Imperial model of malaria transmission. Here we use parameters from
that model to calculate the equilibrium states of Susceptible-Exposed-Infectious (SEI) female mosquitoes
}
\details{
Imperial model sampling is currently only supported for one-node dynamics: a single node with mosquitoes
parameterized by the distribution of human states.
These nodes are set using the \code{node_list} parameter.
Mosquito-only node equilibrium calls \code{\link{equilibrium_lifeycle}}, which
follows one of two models: classic logistic dynamics or the Lotka-Volterra
competition model. This is determined by the parameter \code{log_dd}, and it
changes elements of the return list: \code{K} is returned for logistic dynamics,
or \code{gamma} is returned for Lotka-Volterra dynamics. This
is parameterized with the \code{NF} parameter to define the adult female numbers.
This parameter only needs to be supplied if there are mosquito-only nodes.

For human and mosquito nodes, this function calculates the number of SEI mosquitoes in each state.

The places (\code{spn_P}) object is generated from one of the following:
\code{\link{spn_P_lifecycle_node}}, \code{\link{spn_P_lifecycle_network}},
\code{\link{spn_P_epiSIS_node}}, \code{\link{spn_P_epiSIS_network}},
\code{\link{spn_P_epiSEIR_node}}, or \code{\link{spn_P_epiSEIR_network}}.

The initial population genotype ratios are set by supplying the \code{pop_ratio_Aq},
\code{pop_ratio_F}, and \code{pop_ratio_M} values. The default value is NULL,
and the function will use the wild-type alleles provided in the \code{cube}
object. However, one can supply
several different objects to set the initial genotype ratios. All genotypes provided
must exist in the \code{cube} (this is checked by the function). If a single, named vector
is provided, then all patches will be initialized with the same ratios. If a
matrix is provided, with the number of columns (and column names) giving the
initial genotypes, and a row for each patch, each patch can be set to a different
initial ratio. The three parameters do not need to match each other.

The \code{params} argument supplies all of the ecological and epidemiological
parameters necessary to calculate equilibrium values. This is used to set the
initial population distribution and during the simulation to maintain equilibrium.
This \code{params} must include the following named parameters, noted as being
the same as lifecycle parameters, or new for the epidemiological equilibrium
\itemize{
\item \strong{(Lifecycle parameters)}
\itemize{
\item \code{qE}: inverse of mean duration of egg stage
\item \code{nE}: shape parameter of Erlang-distributed egg stage
\item \code{qL}: inverse of mean duration of larval stage
\item \code{nL}: shape parameter of Erlang-distributed larval stage
\item \code{qP}: inverse of mean duration of pupal stage
\item \code{nP}: shape parameter of Erlang-distributed pupal stage
\item \code{muE}: egg mortality
\item \code{muL}: density-independent larvae mortality
\item \code{muP}: pupae mortality
\item \code{muF}: adult female mortality, supplied from Imperial equilibrium function
\item \code{muM}: adult male mortality, supplied from Imperial equilibrium function
\item \code{beta}: egg-laying rate, daily
\item \code{nu}: mating rate of unmated females
}
\item \strong{(Epidemiological parameters)}
\itemize{
\item \code{NH}: number of humans, can be a vector
\item \code{FOIv}: force of infection on mosquitoes, supplied from Imperial equilibrium function
\item \code{Iv_eq}: per-capita proportion of infectious mosquitoes
The return list contains all of the parameters necessary later in the simulations.
}
}
}
