% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling-ODE.R
\name{step_ODE_decoupled}
\alias{step_ODE_decoupled}
\title{Make Mean-field Approximation (ODE) Numerical Integrator for a SPN Model for Decoupled Epi Dynamics}
\usage{
step_ODE_decoupled(S, Sout, haz, method = "lsoda", human_ode = "SIS")
}
\arguments{
\item{S}{a stoichiometry \code{\link[Matrix]{Matrix-class}} object}

\item{Sout}{an optional matrix to track of event firings. In the deterministic case it will return
the rate of that event at the end of the time step}

\item{haz}{a list of hazard functions}

\item{method}{a character giving the type of numerical integrator used, the default is "lsoda"}

\item{human_ode}{ODE function used for human states}
}
\value{
function closure for use in \code{\link{sim_trajectory_R}} or \code{\link{sim_trajectory_CSV}}
}
\description{
Make a function closure to implement a first order mean-field ODE approximation
for a SPN.
}
\details{
This method is equivalent to considering the ODEs describing the time
evolution of the mean trajectory (first moment) and setting all higher order
moments which appear on the right hand side to zero.

The solvers used within can be found in the \code{deSolve} package, see
\code{\link[deSolve]{ode}}. For inhomogeneous systems, consider using the "rk4"
method to avoid excessive integration times.

The stoichiometry matrix (\code{S}) is generated in \code{\link{spn_S}}.

The list of hazards (\code{haz}) come from \code{\link{spn_hazards}}.

For other samplers, see: \code{\link{step_CLE}}, \code{\link{step_PTS}}, \code{\link{step_DM}}
}
