% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ac_fdr.calc_delta.R
\name{ac_fdr.calc_delta}
\alias{ac_fdr.calc_delta}
\title{Approximate adjustment factor for "False Discovery Rate Control under Archimedean Copula"}
\usage{
ac_fdr.calc_delta(cop, m, m0, alpha = 0.05, num.reps = 1e+05,
  calc.var = FALSE)
}
\arguments{
\item{cop}{The copula}

\item{m}{The number of hypotheses}

\item{m0}{A reasonable lower bound for the number of true hypotheses}

\item{alpha}{the desired significance level}

\item{num.reps}{The number of Monte Carlo simulations to use}

\item{calc.var}{Additionaly calculate the variance (mostly for the examples)}
}
\description{
Approximates the adjustement factor described in Bodnar, Dickhaus (2014) using a Monte Carlo integration.
}
\references{
T. Bodnar and T. Dickhaus (2014). False discovery rate control under Archimedean copula. \emph{Electronic Journal of Statistics} Volume 8, Number 2 (2014), 2207-2241.
}
\keyword{internal}
