% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{remove_average}
\alias{remove_average}
\title{Remove constant component of the signal}
\usage{
remove_average(df, sr, order = 0.5)
}
\arguments{
\item{df}{dataframe. The input multi-channel signal. The first column is
timestamps in POSXlct format. The rest columns are signal values.}

\item{sr}{number. Sampling rate in Hz of the input signal.}

\item{order}{number. Window size (in seconds) of the filter. Default is 500
ms.}
}
\value{
dataframe. Filtered signal.
}
\description{
\code{remove_average} function takes a multi-channel signal and removes the
average value over a filtering window.
}
\details{
This function filters the input multi-channel signal by removing the average
value within each sliding window. The sliding window size is decided by
\eqn{w = sr * order}.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function has been
  considered as one of filtering options during the development of MIMS-unit
  algorithm. But the released version of MIMS-unit algorithm does not use
  this function for filtering.
}

\examples{
  # Use sample data
  df = sample_raw_accel_data

  # View input
  illustrate_signal(df, plot_maxed_out_line = FALSE)

  # Apply filtering
  output = remove_average(df, sr=80, order=0.5)

  # View output
  illustrate_signal(output, plot_maxed_out_line = FALSE)
}
\seealso{
Other filtering functions: 
\code{\link{bandlimited_interp}()},
\code{\link{bessel}()},
\code{\link{iir}()}
}
\concept{filtering functions}
