% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.MLGL.R
\name{cv.MLGL}
\alias{cv.MLGL}
\title{Multi-Layer Group-Lasso with cross V-fold validation}
\usage{
cv.MLGL(
  X,
  y,
  nfolds = 5,
  lambda = NULL,
  hc = NULL,
  weightLevel = NULL,
  weightSizeGroup = NULL,
  loss = c("ls", "logit"),
  intercept = TRUE,
  sizeMaxGroup = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{X}{matrix of size n*p}

\item{y}{vector of size n. If loss = "logit", elements of y must be in {-1,1}}

\item{nfolds}{number of folds}

\item{lambda}{lambda values for group lasso. If not provided, the function generates its own values of lambda}

\item{hc}{output of \code{\link{hclust}} function. If not provided, \code{\link{hclust}} is run with ward.D2 method}

\item{weightLevel}{a vector of size p for each level of the hierarchy. A zero indicates that the level will be ignored. If not provided, use 1/(height between 2 successive levels)}

\item{weightSizeGroup}{a vector}

\item{loss}{a character string specifying the loss function to use, valid options are: "ls" least squares loss (regression) and "logit" logistic loss (classification)}

\item{intercept}{should an intercept be included in the model ?}

\item{sizeMaxGroup}{maximum size of selected groups. If NULL, no restriction}

\item{verbose}{print some informations}

\item{...}{Others parameters for \code{\link{cv.gglasso}} function}
}
\value{
a cv.MLGL object containing :
\describe{
\item{lambda}{values of \code{lambda}.}
\item{cvm}{the mean cross-validated error.}
\item{cvsd}{estimate of standard error of \code{cvm}}
\item{cvupper}{upper curve = \code{cvm+cvsd}}
\item{cvlower}{lower curve = \code{cvm-cvsd}}
\item{lambda.min}{The optimal value of \code{lambda} that gives minimum cross validation error \code{cvm}.}
\item{lambda.1se}{The largest value of \code{lambda} such that error is within 1 standard error of the minimum.}
\item{time}{computation time}
}
}
\description{
V-fold cross validation for \code{\link{MLGL}} function
}
\details{
Hierarhical clustering is performed with all the variables. Then, the partitions from the different
 levels of the hierarchy are used in the differents run of MLGL for cross validation.
}
\examples{
set.seed(42)
# Simulate gaussian data with block-diagonal variance matrix containing 12 blocks of size 5
X <- simuBlockGaussian(50, 12, 5, 0.7)
# Generate a response variable
y <- X[, c(2,7,12)] \%*\% c(2, 2, -2) + rnorm(50,0,0.5)
# Apply cv.MLGL method
res <- cv.MLGL(X, y)

}
\seealso{
\link{MLGL}, \link{stability.MLGL}, \link{predict.cv.gglasso}, \link{coef.cv.MLGL}, \link{plot.cv.MLGL}
}
\author{
Quentin Grimonprez
}
