% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporalComposite.R
\name{temporalComposite}
\alias{temporalComposite}
\title{Calculate MODIS Composite Images}
\usage{
temporalComposite(x, y, timeInfo = extractDate(x, asDate =
  TRUE)$inputLayerDates, interval = c("month", "year", "fortnight"),
  fun = max, na.rm = TRUE, cores = 1L, filename = "", ...)
}
\arguments{
\item{x}{\code{Raster*} or \code{character}. MODIS vegetation index.}

\item{y}{\code{Raster*} or \code{character}. MODIS
"composite_day_of_the_year" SDS associated with 'x'.}

\item{timeInfo}{\code{Date} vector corresponding to all input layers. If not 
further specified, this is tried to be created through invoking 
\code{\link{extractDate}} upon 'x', assuming standard MODIS file names.}

\item{interval}{\code{character}. Time period for aggregation, see
\code{\link{aggInterval}}.}

\item{fun, na.rm}{\code{function}. See \code{\link{overlay}}.}

\item{cores}{\code{integer}. Number of cores for parallel processing.}

\item{filename}{\code{character}. Optional output filename.}

\item{...}{Additional arguments passed to \code{\link{writeRaster}}.}
}
\value{
A \code{Raster*} object.
}
\description{
Based on a user-defined function, e.g. \code{max} for maximum value
composites (MVC), aggregate native 16-day MODIS datasets to custom temporal
composites.
}
\examples{
\dontrun{
library(mapview)
frc <- as(subset(franconia, district == "Mittelfranken"), "Spatial")
tfs <- runGdal("MOD13A1", begin = "2015001", end = "2016366", extent = frc,
            job = "temporalComposite", SDSstring = "100000000010")

ndvi <- sapply(tfs[[1]], "[[", 1)
cdoy <- sapply(tfs[[1]], "[[", 2)

mmvc <- temporalComposite(ndvi, cdoy)
plot(mmvc[[1:4]])
}

}
\seealso{
\code{\link{aggInterval}}, \code{\link{calc}}, \code{\link{writeRaster}}.
}
\author{
Florian Detsch
}
