% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_population.R
\name{update_population}
\alias{update_population}
\title{Update population}
\usage{
update_population(update, ...)
}
\arguments{
\item{update}{List containing the population update parameters. See
Section \verb{Update Strategies} of the \code{\link[=moead]{moead()}} documentation for
details.}

\item{...}{other parameters to be passed down to the specific
\code{updt_}\strong{xyz}\verb{()} routines.}
}
\value{
List object containing the updated values of the population matrix
\code{X}, objective function matrix \code{Y}, and constraint values list \code{V}, as well
as an updated Archive list containing its corresponding components \code{X}, \code{Y}
and \code{V}.
}
\description{
Selection and population update procedures for the MOEA/D
}
\details{
This update routine is intended to be used internally by the main \code{\link[=moead]{moead()}}
function, and should not be called directly by the user. The list of
available update methods can be generated using \code{\link[=get_update_methods]{get_update_methods()}}.
}
\section{References}{

F. Campelo, L.S. Batista, C. Aranha (2020): The {MOEADr} Package: A
Component-Based Framework for Multiobjective Evolutionary Algorithms Based on
Decomposition. Journal of Statistical Software \doi{10.18637/jss.v092.i06}\cr
}

