% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm.r
\name{spmprojDet}
\alias{spmprojDet}
\title{spmprojDet conducts forward projections from known conditions}
\usage{
spmprojDet(spmobj, projcatch, projyr = 10, plotout = FALSE, useft = 7)
}
\arguments{
\item{spmobj}{the list generated by the function spm}

\item{projcatch}{the projected constant catch levels as a vector}

\item{projyr}{the number of years of projection. default = 10}

\item{plotout}{should the projection be plotted? default=FALSE}

\item{useft}{which font used in a plot? default=7 = bold times}
}
\value{
the projected biomass, CPUE, and the projected years
}
\description{
spmprojDet conducts deterministic forward projections of the 
    dynamics of a fitted surplus production model. The paramters and 
    original data need to be put through the function spm to form the 
    spmobj, i.e. the list generated by the function spm. This contains 
    all required information except for details of the projection.
    The application of spm is where the dynamics are defined as
    either Schaefer or Fox. If no plot is generated then the 
    projected dynamics are output invisibly, where the biomass and
    predCE are matrices of years vs projcatch.
}
\examples{
 data(abdat)
 param <- log(c(r=0.3,K=11500,Binit=3300,sigma=0.05))
 bestmod <- nlm(f=negLL1,p=param,funk=simpspm,logobs=log(abdat$cpue),
                indat=abdat,typsize=magnitude(param),iterlim=1000,
                schaefer=FALSE)
 out <- spm(bestmod$estimate,indat=abdat,schaefer=FALSE)
 catches <- seq(700,1000,50)
 spmprojDet(spmobj = out,projcatch=catches,projyr=10,plotout=TRUE)
}
