% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.r
\docType{data}
\name{LatA}
\alias{LatA}
\title{LatA Simulated length-at-age for 358 female fish}
\format{
A data.frame with 358 rows and 2 variables:
\describe{
  \item{age}{simulated ages in years}
  \item{length}{consequent simulated fork length of the fish, in cms}
}
}
\source{
The data this simulation is based upon is from length-at-age 
    data for one species collected over many years by the many 
    excellent people running the Integrated Stock Monitoring Program 
    in the Australian South East Fishery over the years of its 
    existence. The simulation is based on a characterization of 
    redfish properties and includes random error in the hypothetical 
    measurements as well as the processes of growth (i.e. both 
    measurement and process error). The other inputs were a selected 
    set of growth parameters and the relative frequency of different 
    ages vs lengths.
}
\description{
A data.frame containing the simulated 
    age for an array of different lengths based upon the properties
    of an extensive collection of redfish (\emph{Centroberyx affinis}) 
    length-at-age data from eastern Australia sampled in the 1990's.
}
\section{Subjects}{

 \itemize{
  \item Estimating individual growth from length-at-age data
  \item von Bertalanffy growth curve
  \item Gompertz growth curve
  \item Michaelis-Menton curve used as a growth curve 
 }
}

\examples{
  data(LatA)
  pars <- c(27.0,0.15,-2.0) # von Bertalanffy
  bestvB <- nlm(f=ssq,funk=vB,observed=LatA$length,p=pars,
                ages=LatA$age,typsize=magnitude(pars))
  outfit(bestvB,backtran=FALSE,title="vB")
}
