% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfuns.R
\name{plot1}
\alias{plot1}
\title{plot1 a quick way to plot an xy line or point plot}
\usage{
plot1(
  x,
  y,
  xlab = "",
  ylab = "",
  type = "l",
  usefont = 7,
  cex = 0.75,
  maxy = 0,
  defpar = TRUE,
  ...
)
}
\arguments{
\item{x}{The single vector of x data}

\item{y}{the single vector of y data. If more are required they can
be added separately after calling plot1.}

\item{xlab}{the label for the x-axis, defaults to empty}

\item{ylab}{the label for the y-axis, defaults to empty}

\item{type}{the type of plot "l" is for line, the default, "p" is
points. If you want both, then plot a line and add points afterwards.}

\item{usefont}{which font to use, defaults to 7 which is Times bold}

\item{cex}{the size of the fonts used. defaults to 0.75}

\item{maxy}{defaults to 0, which does nothing. If a value is given
then this value is used rather than estimating from the input y}

\item{defpar}{if TRUE then plot1 will declare a par statement. If false 
it will expect one outside the function. In this way plot1 can be
used when plotting multiple graphs, perhaps as mfrow=c(2,2)}

\item{...}{required to allow the plot to access other parameters 
without having to explicitly declare them in plot1, these include
col, default = black, pch, if the type = "p", lwd, etc.}
}
\value{
plots a graph and sets the default plotting par values. 
    This changes the current plotting options! The original par 
    values are returned invisibly if the user wishes to reset.
}
\description{
plot1 provides a quick way to plot out a single xy
    line or point plot. It can be used with plotprep to generate a 
    plot outside of Rstudio or by itself to generate one within 
    Rstudio. It uses a standard par setup and permits custom labels, 
    font, and font size (cex). It checks the spread of y and if a 
    ymax is not given in the parameters finds the ymax and checks 
    to see if y goes negative in which case it uses getmin, so the
    y-axis is set to 0 - ymax or ymin - ymax
}
\examples{
 x <- rnorm(20,mean=5,sd=1)
 oldpar <- plot1(x,x,xlab="x-values",ylab="yvalues")
 points(x,x,pch=16,cex=1.5)
 y <- rnorm(20,mean=5,sd=1)
 plot1(x,y,type="p",cex=1.2,panel.first=grid())
 par(oldpar)
}
