% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_MRF.R
\name{predict_MRF}
\alias{predict_MRF}
\title{Predict training observations from fitted MRFcov models}
\usage{
predict_MRF(data, MRF_mod, prep_covariates = TRUE, n_cores)
}
\arguments{
\item{data}{Dataframe. The input data to be predicted, where the \code{n_nodes}
left-most variables are binary occurrences to be represented by nodes in the graph.
Colnames from this sample dataset must exactly match the colnames in the dataset that
was used to fit the \code{MRF_mod}}

\item{MRF_mod}{A fitted \code{\link{MRFcov}} or \code{\link{MRFcov_spatial}}model object}

\item{prep_covariates}{Logical flag stating whether to prep the dataset
by cross-multiplication (\code{TRUE} by default; \code{FALSE} when used in other functions)}

\item{n_cores}{Positive integer stating the number of processing cores to split the job across.
Default is \code{parallel::detect_cores() - 1}}
}
\value{
A \code{matrix} containing predictions for each observation in \code{data}. If
\code{family = "binomial"}, a second element containing binary
predictions for nodes is returned.
}
\description{
This function calculates linear predictors for node observations
using coefficients from an \code{\link{MRFcov}} or \code{\link{MRFcov_spatial}} object.
}
\details{
Observations for nodes in \code{data} are predicted using linear predictions
from \code{MRF_mod}. If \code{family = "binomial"}, a second element containing binary
predictions for nodes is returned. Note that predicting values for unobserved locations using a
spatial MRF is not currently supported
}
\examples{
\donttest{
data("Bird.parasites")
# Fit a model to a subset of the data (training set)
CRFmod <- MRFcov(data = Bird.parasites[1:300, ], n_nodes = 4, family = "binomial")

# If covariates are included, prep the dataset for gathering predictions
prepped_pred <- prep_MRF_covariates(Bird.parasites[301:nrow(Bird.parasites), ], n_nodes = 4)

# Predict occurrences for the remaining subset (test set)
predictions <- predict_MRF(data = prepped_pred, MRF_mod = CRFmod)

# Visualise predicted occurrences for nodes in the test set
predictions$Binary_predictions

# Predicting spatial MRFs requires the user to supply the spatially augmented dataset
data("Bird.parasites")
Latitude <- sample(seq(120, 140, length.out = 100), nrow(Bird.parasites), TRUE)
Longitude <- sample(seq(-19, -22, length.out = 100), nrow(Bird.parasites), TRUE)
coords <- data.frame(Latitude = Latitude, Longitude = Longitude)
CRFmod_spatial <- MRFcov_spatial(data = Bird.parasites, n_nodes = 4,
                                family = 'binomial', coords = coords)
predictions <- predict_MRF(data = CRFmod_spatial$mrf_data,
                          prep_covariates  = FALSE,
                          MRF_mod = CRFmod_spatial)}

}
\references{
Clark, NJ, Wells, K and Lindberg, O.
Unravelling changing interspecific interactions across environmental gradients
using Markov random fields. (2018). Ecology doi: 10.1002/ecy.2221
\href{http://nicholasjclark.weebly.com/uploads/4/4/9/4/44946407/clark_et_al-2018-ecology.pdf}{Full text here}.
}
\seealso{
\code{\link{MRFcov}}, \code{\link{cv_MRF_diag}}
}
