# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Build quartet table from distances
#'
#' This is a C++ function, called from quartetTable, to fill in the quartet counts.
#' From a list of topological distance matrices (1 for each gene tree) it determines all
#' gene quartets. It is not intended to be used as a stand-alone function, and hence not fully
#' documented. The faster looping in C++ over R gives substantial time improvements
#'
#' @param dList a list of distance matrices
#' @param M number of sets of 4 taxa
#' @param nt number of gene trees/distance matrices
#' @param Q matrix to fill out as table of quartet counts
#' @param random if 0 compute for all sets of 4 taxa, otherwise for M random ones
#' @seealso \code{\link{quartetTable}}, \code{\link{quartetTableParallel}}
#'
#' @export
quartetTallyCpp <- function(dList, M, nt, Q, random) {
    .Call('_MSCquartets_quartetTallyCpp', PACKAGE = 'MSCquartets', dList, M, nt, Q, random)
}

