% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Misc_Exported.R
\name{hconv}
\alias{hconv}
\alias{R0conv}
\alias{SRalphaconv}
\alias{SRbetaconv}
\title{Stock recruit parameterization}
\usage{
hconv(alpha, phi0, SR = 1, type = 1)

R0conv(alpha, beta, phi0, SR = 1, type = 1)

SRalphaconv(h, phi0, SR = 1, type = 1)

SRbetaconv(h, R0, phi0, SR = 1, type = 1)
}
\arguments{
\item{alpha}{Alpha parameter}

\item{phi0}{Unfished spawners per recruit}

\item{SR}{Stock-recruit function: (1) Beverton-Holt, or (2) Ricker}

\item{type}{The parameterization of the Beverton-Holt function with respect to \code{alpha}
and \code{beta}. See details.}

\item{beta}{Beta parameter}

\item{h}{Steepness parameter}

\item{R0}{Unfished recruitment parameter}
}
\value{
A numeric.
}
\description{
Convert stock recruit parameters from steepness parameterization to alpha/beta (and vice versa)
}
\details{
The Type 1 Beverton-Holt equation is
\deqn{R = \alpha S/(1 + \beta S)}

The Type 2 Beverton-Holt equation is
\deqn{R = S/(\alpha + \beta S)}

The Ricker equation is
\deqn{R = \alpha S \exp(-\beta S)}
}
\section{Functions}{
\itemize{
\item \code{hconv()}: Returns steepness (h) from \code{alpha} and \code{phi0}

\item \code{R0conv()}: Returns unfished recruitment (R0) from \code{alpha}, \code{beta}, and \code{phi0}

\item \code{SRalphaconv()}: Returns \code{alpha} from \code{h} and \code{phi0}

\item \code{SRbetaconv()}: Returns \code{beta} from \code{h}, \code{R0}, and \code{phi0}

}}
\author{
Q. Huynh
}
