% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSE_functions.R, R/Misc_Exported.R
\name{checkMSE}
\alias{checkMSE}
\alias{addMPs}
\alias{joinMSE}
\alias{joinHist}
\alias{updateMSE}
\title{Utility functions for MSE objects}
\usage{
checkMSE(MSEobj)

addMPs(MSEobjs)

joinMSE(MSEobjs = NULL)

joinHist(Hist_List)

updateMSE(MSEobj, save.name = NULL)
}
\arguments{
\item{MSEobj}{A \code{MSE} object}

\item{MSEobjs}{A list of MSE objects}

\item{Hist_List}{A list of objects of class \code{Hist}}

\item{save.name}{Character string. Optional file name to save the updated MSE object to disk.}
}
\value{
An object of class \code{MSE}

A new object of class \code{Hist}
}
\description{
Utility functions for MSE objects
}
\section{Functions}{
\itemize{
\item \code{checkMSE()}: Check that an MSE object includes all slots in the latest version of DLMtool

\item \code{addMPs()}: Adds additional MPs to an MSE object by combining
multiple MSE objects that have identical historical OM values but different
MPs.

\item \code{joinMSE()}: Joins two or more MSE objects together across simulations. MSE objects must have identical
number of historical years, and projection years.

\item \code{joinHist()}: Join objects of class \code{Hist}. Does not join slot \code{OM}

\item \code{updateMSE()}: Updates an existing MSE object (class MSE) from a previous version of the
MSEtool to include slots new to the latest version. Also works with Stock,
Fleet, Obs, Imp, and Data objects. The new slots will be empty,
but avoids the 'slot doesn't exist' error that sometimes occurs.
Returns an object of class matching class(MSEobj)

}}
\seealso{
\code{\link[=addMMPs]{addMMPs()}}

\link{joinData}
}
\author{
A. Hordyk
}
