% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDW.R
\name{CDW}
\alias{CDW}
\title{Identification of confirmed disability worsening events}
\usage{
CDW(Visits, mconf = 3 * 30.25, tRelapse = 30, sustained = TRUE)
}
\arguments{
\item{Visits}{A data frame consisting of 6 columns: ID, dateEDSS, EDSS, daysPostRelapse (days since most recent relapse), bEDSS (baseline EDSS score), base.date (date of bEDSS).}

\item{mconf}{Confirmation period (days) for EDSS worsening.}

\item{tRelapse}{Minimum time in days since the most recent relapse to EDSS assessment.}

\item{sustained}{If TRUE, the default, identifies only those EDSS worsening events sustained for the remaining recorded follow-up.}
}
\value{
A data frame.
}
\description{
Identify disability worsening events confirmed over a specified time period. The identification of events is based on clinical visit records, with each record including entries for patient code, visit date, Expanded Disability Status Scale (EDSS) score, and days since the most recent relapse.
If a baseline EDSS score is not provided, it is determined as the first EDSS score recorded in the dataset outside 30 days (the default) of a relapse.
Following a confirmed disability worsening event, the minimum EDSS score within the confirmation period, regardless of the recency of a relapse, becomes the new baseline EDSS score.
By default, only identify those worsening events that are sustained for the remainder of the follow-up.
}
\examples{
data(SampleData)
output<-CDW(SampleData)
}
\references{
Kalincik, et al. Brain 2015;138(11):3287-3298.
}
