% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotref.R
\name{plotref}
\alias{plotref}
\title{Plots individual's z-scores and percentiles on references curves.}
\usage{
plotref(age = 10, sex = 1, muac, graphtype = "z-scores")
}
\arguments{
\item{age}{a numeric value (in years) between 5 and 19.}

\item{sex}{preferably numeric (1 = Male, 2 = Female). Strings can also be used.}

\item{muac}{a numeric value in cm between 5 and 50.}

\item{graphtype}{requires the user to specify the type of the reference curves to be plotted.
Arguments can be "z-scores" or "percentiles".}
}
\value{
Plots z-scores or percentiles with a mark indicating where the individual person lies within the standardized reference curves.
}
\description{
Plots individual's z-scores and percentiles on standardized reference curves for children and
adolescents aged 5 to 19 years to assess nutritional and health status,
 and  define risk of adverse health events for the given individual.
}
\examples{
 ## Plot individual's z-scores and percentiles on standardized reference curves.
 p1 <- plotref(age=13, sex=1, muac=25) # Boy's Z-score
 p2 <- plotref(age=13, sex=1, muac=25, graphtype="percentiles") # Boy's Percentile
 p3 <- plotref(age=12, sex=2, muac=22) # Girl's Z-score
 p4 <- plotref(age=12, sex=2, muac=22, graphtype="percentiles") # Girl's Percentile

}
\references{
Mramba L., Ngari M., Mwangome M., Muchai L., Bauni E., Walker A.S., Gibb D.M., Fegan G. and Berkley J.A. (2017)
\emph{A growth reference for mid upper arm circumference for age among school age children and adolescents, and validation for mortality: growth curve construction and longitudinal cohort study}
BMJ 2017;358:j3423 <doi:10.1136/bmj.j3423> <https://www.bmj.com/content/358/bmj.j3423>

<https://www.who.int/childgrowth/standards/Technical_report.pdf>

<https://www.who.int/childgrowth/standards/ac_for_age/en/>
}
\seealso{
\code{\link{indivmuaczs}} and \code{\link{muaczs}}.
}
