% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cn.region.heatmap.R
\name{cn.region.heatmap}
\alias{cn.region.heatmap}
\title{A Function for Creating a Heatmap of DNA Copy Number Data}
\usage{
cn.region.heatmap(cn.mat, gene.annot, plot.chr, plot.start, plot.stop,
  plot.list, sample.annot = NULL, sample.cluster = F, low.thresh = -2,
  high.thresh = 2, num.cols = 50, collist = c("blue", "white", "red"),
  annot.colors = c("black", "red", "green", "blue", "cyan"),
  plot.sample.annot = F, cytoband.colors = c("gray90", "gray60"))
}
\arguments{
\item{cn.mat}{A matrix of gene-level DNA copy number data (rows = genes, columns = samples).
DNA methylation data can also be used.  Both row names (gene names) and column names (Sample IDs) must be given.}

\item{gene.annot}{A three-column matrix containing gene position information.  Column 1 = chromosome number written in 
the form 'chr1' (note that chrX and chrY should be written chr23 and chr24), Column 2 = position (in base pairs), Column 3 = cytoband.}

\item{plot.chr}{The chromosome used to define the region of interest.}

\item{plot.start}{The genomic position (in base pairs) where the region starts.}

\item{plot.stop}{The genomic position (in base pairs) where the region stops.}

\item{plot.list}{A list produced by corr.list.compute().}

\item{sample.annot}{An optional two-column matrix of sample annotation data.  Column 1 = sample IDs, Column 2 = sample annotation 
(e.g. tumor vs. normal).  If NULL, sample annot will be created using the common sample IDs and a single group ('1').  Default = NULL.}

\item{sample.cluster}{Logical values indicating whether the samples should be clustered.  Default = FALSE.}

\item{low.thresh}{Lower threshold for DNA copy number measurements.  All values less than low.thresh are set equal to low.thresh.  Default = -2.}

\item{high.thresh}{Upper threshold for DNA copy number measurements.  All values greater than high.thresh are set equal to high.thresh.  Default = 2.}

\item{num.cols}{Number of distinct colors in the heatmap.  Default = 50.}

\item{collist}{Color scheme for displaying copy number values.  Default = ("blue", "white", "red").}

\item{annot.colors}{Character vector used to define the color scheme for sample annotation.  Default = c("black", "red", "green", "blue", "cyan").}

\item{plot.sample.annot}{Logical value used to specify whether the sample annotation information should be plotted.  Default = FALSE.}

\item{cytoband.colors}{Character vector of length two used to define the color scheme for annotating the cytoband.  Default = c("gray90", "gray60").}
}
\description{
This function creates a heatmap of DNA copy number data for a given chromosomal region.
}
\examples{
exp.mat = tcga.exp.convert(exp.mat)

 cn.mat = tcga.cn.convert(cn.mat)

 prepped.data = data.prep(exp.mat, cn.mat, gene.annot, sample.annot, log.exp = FALSE)

 pd.exp = prepped.data[["exp"]]

 pd.cn = prepped.data[["cn"]]

 pd.ga = prepped.data[["gene.annot"]]

 pd.sa = prepped.data[["sample.annot"]]

 output.list = corr.list.compute(pd.exp, pd.cn, pd.ga, pd.sa)

 cn.region.heatmap(cn.mat = pd.cn, gene.annot = pd.ga, plot.chr = 11,

plot.start = 0e6, plot.stop = 135e6, sample.annot = pd.sa, plot.list = output.list)

}
