% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precheck.R
\name{preCheck}
\alias{preCheck}
\title{Step4: Pre-check for token usage in experiment design.}
\usage{
preCheck(
  data,
  checkToken = FALSE,
  systemPrompt = "",
  modality = "base",
  imgDetail = "auto",
  version = "2023-06-01",
  ...
)
}
\arguments{
\item{data}{A data.frame that has been structured by the 'experimentDesign' function, containing the experimental setup.}

\item{checkToken}{Whether to perform token count check, select TRUE to submit your experiment to our server's tokenizer for token count check, the default selection is FALSE (i.e., no token check will be performed, but you need to manually check if the number of tokens exceeds the model limit to avoid errors in the experiment).}

\item{systemPrompt}{The system prompt text used in the chatGPT model interaction. If left empty, a space character is assumed.Note: This parameter does not work in models that do not support system prompts.}

\item{modality}{The default mode of GPT is "base," with "img" as an optional choice.}

\item{imgDetail}{The image quality of the img modality is set to auto by default, with low/high as selectable options.}

\item{version}{When using the Claude model, the version parameter required defaults to "2023-06-01".}

\item{...}{Variable parameter lists allow you to input additional parameters supported by the model you're using, such as n=2 / logprobs=TRUE... Note: You must ensure the validity of the parameters you enter; otherwise, an error will occur.}
}
\value{
A list containing the original data and the parameters for the chatGPT model interaction, confirming that the setup has passed the token checks or indicating issues if found.
}
\description{
Configures experimental parameters before execution.
}
\examples{

df <- data.frame(
Run = c(1,2),
Item = c(1,2),
Event =c(1,1),
Condition = c(1,2),
TargetPrompt = c("1","2")
)

ExperimentItem=loadData(df$Run,df$Item,df$Event,df$Condition,promptList = df$TargetPrompt)

Design=experimentDesign(ExperimentItem,session=1)

gptConfig=preCheck(Design, systemPrompt="You are a participant in a psycholinguistic experiment",
                   modality='base',imgDetail="low",temperature=0.7)

}
