% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_RandomForestModel.R
\name{RandomForestModel}
\alias{RandomForestModel}
\title{Random Forest Model}
\usage{
RandomForestModel(ntree = 500, mtry = .(if (is.factor(y))
  floor(sqrt(nvars)) else max(floor(nvars/3), 1)), replace = TRUE,
  nodesize = .(if (is.factor(y)) 1 else 5), maxnodes = NULL)
}
\arguments{
\item{ntree}{number of trees to grow.}

\item{mtry}{number of variables randomly sampled as candidates at each split.}

\item{replace}{should sampling of cases be done with or without replacement?}

\item{nodesize}{minimum size of terminal nodes.}

\item{maxnodes}{maximum number of terminal nodes trees in the forest can
have.}
}
\value{
\code{MLModel} class object.
}
\description{
Implementation of Breiman's random forest algorithm (based on Breiman and
Cutler's original Fortran code) for classification and regression.
}
\details{
\describe{
\item{Response Types:}{\code{factor}, \code{numeric}}
\item{\link[=tune]{Automatic Tuning} Grid Parameters:}{
  \code{mtry}, \code{nodesize}*
}
}
* included only in randomly sampled grid points

Default values for the \code{NULL} arguments and further model details can be
found in the source link below.
}
\examples{
library(MASS)

fit(medv ~ ., data = Boston, model = RandomForestModel())

}
\seealso{
\code{\link[randomForest]{randomForest}}, \code{\link{fit}},
\code{\link{resample}}, \code{\link{tune}}
}
