% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/performance_curve.R
\name{performance_curve}
\alias{performance_curve}
\alias{Curves}
\alias{performance_curve.Resamples}
\alias{performance_curve.default}
\title{Performance Curves}
\usage{
Curves(...)

performance_curve(x, ...)

\method{performance_curve}{Resamples}(x, metrics = c(MachineShop::tpr,
  MachineShop::fpr), na.rm = TRUE, ...)

\method{performance_curve}{default}(x, y, metrics = c(MachineShop::tpr,
  MachineShop::fpr), ...)
}
\arguments{
\item{...}{named or unnamed \code{performance_curve} output to combine
together with the \code{Curves} constructor.}

\item{x}{observed responses or \code{Resamples} object of observed and
predicted responses.}

\item{metrics}{list of two performance metrics for the analysis [default: ROC
metrics].  Precision recall curves can be obtained with 
\code{c(precision, recall)}.}

\item{na.rm}{logical indicating whether to remove observed or predicted
responses that are \code{NA} when calculating metrics.}

\item{y}{predicted responses.}
}
\value{
\code{Curves} class object that inherits from \code{data.frame}.
}
\description{
Curves for the analysis of tradeoffs between metrics for assessing
performance in classifying binary outcomes over the range of possible
cutoff probabilities.  Available curves include receiver operating
characteristic (ROC) and precision recall.
}
\examples{
library(MASS)

res <- resample(type ~ ., data = Pima.tr, model = GBMModel)

## ROC curve
roc <- performance_curve(res)
plot(roc)
auc(roc)

}
\seealso{
\code{\link{response}}, \code{\link{predict}},
\code{\link{resample}}, \code{\link{metrics}}, \code{\link{auc}},
\code{\link{plot}}, \code{\link{summary}}
}
