% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location_getSingleAddress_Photon.R
\name{location_getSingleAddress_Photon}
\alias{location_getSingleAddress_Photon}
\title{Get address data from the Photon API to OpenStreetMap}
\usage{
location_getSingleAddress_Photon(
  longitude = NULL,
  latitude = NULL,
  baseUrl = "https://photon.komoot.io/reverse",
  verbose = TRUE
)
}
\arguments{
\item{longitude}{Single longitude in decimal degrees E.}

\item{latitude}{Single latitude in decimal degrees N.}

\item{baseUrl}{Base URL for data queries.}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
List of address components.
}
\description{
The Photon API is used get address data associated with
the \code{longitude} and \code{latitude}. The following list of data
is returned:

\itemize{
\item{\code{houseNumber}}
\item{\code{street}}
\item{\code{city}}
\item{\code{stateCode}}
\item{\code{stateName}}
\item{\code{postalCode}}
\item{\code{countryCode}}
\item{\code{countryName}}
}

The function makes an effort to convert both \code{state} and \code{country}
\code{Name} into \code{Code} with codes defaulting to \code{NA}. Both
\code{Name} and \code{Code} are returned so that improvements can be made in
the conversion algorithm.
}
\examples{
\donttest{
library(MazamaLocationUtils)

# Fail gracefully if any resources are not available
try({

  # Set up standard directories and spatial data
  spatialDataDir <- tempdir() # typically "~/Data/Spatial"
  initializeMazamaSpatialUtils(spatialDataDir)

  # Wenatchee
  lon <- -120.325278
  lat <- 47.423333

  addressList <- location_getSingleAddress_Photon(lon, lat)
  str(addressList)
  
}, silent = FALSE)
}

}
\references{
\url{https://photon.komoot.io}
}
