% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/getCountryName.R
\name{getCountryName}
\alias{getCountryName}
\title{Return Country Names at Specified Locations}
\usage{
getCountryName(lon, lat, dataset = "SimpleCountries", countryCodes = NULL,
  allData = FALSE)
}
\arguments{
\item{lon}{vector of longitudes in decimal degrees}

\item{lat}{vector of latitudes in decimal degrees}

\item{dataset}{name of spatial dataset to use}

\item{countryCodes}{vector of countryCodes}

\item{allData}{logical specifying whether a full dataframe should be returned}
}
\value{
Vector of country names in English.
}
\description{
Uses spatial comparison to determine which country polygons the
    locations fall into and returns the country name for those polygons.

    If \code{allData=TRUE}, additional data is returned.
}
\examples{
lon <- seq(0,50)
lat <- seq(0,50)
getCountryName(lon,lat)
}
\references{
\url{http://www.naturalearthdata.com/downloads/10m-cultural-vectors/}
}
\seealso{
SimpleCountries

getSpatialData
}
\keyword{locator}

