\name{ADSSModExample1}
\alias{ADSSModExample1}
\title{
Simulation-based design of an adaptive trial with sample size re-estimation (normally distributed endpoint)
}
\description{
Consider a seamless Phase II/Phase III or Phase III trial with a normally distributed primary efficacy endpoint. A larger value of the endpoint corresponds to a more favorable outcome. A single dose or regimen of an experimental treatment will be compared to a control. An adaptive design with two interim analyses will be employed in the trial (the first interim analysis may correspond to the end of the Phase II portion of the trial). The following decision rules will be applied at the interim looks:
\itemize{
	\item Futility stopping rule will be applied at the first interim analysis (IA1). The trial may be stopped due to futility if a significant treatment effect is unlikely to be established at the final analysis (FA), i.e., the predicted probability of success (conditional power) is very low at this interim analysis.
    \item Sample size re-estimation rule will be applied at the second interim analysis (IA2). The total number of patients in the trial will be increased to boost the probability of success if the predicted probability of success (conditional power) is lower than expected at this interim analysis.
} 
The following design parameters will be assumed:
\itemize{
    \item A balanced design with 120 enrolled patients per arm will be utilized.
    \item The patient dropout rate is equal to 5\%, i.e., 5\% of the patients are expected to be lost to follow up by the end of the treatment period.
    \item The information fractions at IA1 and IA2 are set to 40\% and 60\%, i.e., the first and second interim looks will be taken after 40\% and 60\% of the patients complete the treatment period or drop out of the trial before completing the treatment period. 
}
In addition, the following decision rules will be considered at the two interim analyses:
\itemize{
    \item The futility threshold at IA1 is set to 10\%, i.e., the trial will be terminated for futility if conditional power does not exceed 10\%.
    \item The promising interval at IA2 ranges from 50\% to 90\%, i.e., the sample size in the trial will be increased if conditional power is greater than 50\% and less than 90\%.
    \item The target conditional power at IA2 is set to 90\%, i.e., the sample size will be increased to ensure conditional power of 90\% up a pre-defined cap. The maximum increase is equal to 30\% of the original sample size.
}
Finally, the mean effects in the control and treatment arms are assumed to be equal to 0 and 0.3, respectively, with a common standard deviation of 1.

Key operating characteristics of this adaptive design will be evaluated using the \code{\link{ADSSMod}} function with 10,000 simulation runs. To invoke this function, a list of all design and decision rule parameters (\code{parameters}) needs to be created as shown below. A comprehensive simulation report can be generated by calling the \code{\link{GenerateReport}} function and a graphical user interface can be launched using the \code{\link{ADSSModApp}} function.
}
\arguments{No arguments}
\value{No return value}
\seealso{
  \code{\link{ADSSMod}}, \code{\link{ADSSModExample2}}, \code{\link{ADSSModExample3}}
}
\examples{
# List of all parameters
parameters = list()

# Endpoint type
parameters$endpoint_type = "Normal"

# Direction of favorable outcome
parameters$direction = "Higher"

# Number of enrolled patients (control, treatment) 
parameters$sample_size = c(120, 120)

# Patient dropout rate
parameters$dropout_rate = 0.05

# Mean and SD in the control arm 
parameters$control_mean = 0
parameters$control_sd = 1

# Mean and SD in the treatment arm 
parameters$treatment_mean = 0.3
parameters$treatment_sd = 1

# Information fractions at IA1, IA2, FA (before sample size adjustment) 
# and FA (after sample size adjustment)
parameters$info_frac = c(0.4, 0.6, 1, 1.3)

# Futility threshold for conditional power at IA1
parameters$futility_threshold = 0.1

# Promising interval for conditional power at IA2
parameters$promising_interval = c(0.5, 0.9)

# Target conditional power for increasing the sample size at IA2
parameters$target_power = 0.9

# One-sided alpha level
parameters$alpha = 0.025

# Number of simulations, you should prefer more
parameters$nsims = 100

# Run simulations to compute operating characteristics
results = ADSSMod(parameters)

# Generate a simulation report (remove tempfile)
GenerateReport(results, 
              tempfile("ADSSMod Normally distributed endpoint.docx", fileext=".docx"))
}