% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2skat.R
\name{Mega2SKAT}
\alias{Mega2SKAT}
\title{execute the CRAN SKAT function on a subset of the gene transcripts}
\usage{
Mega2SKAT(f, ty, gs = 1:100, genes = NULL, skat = SKAT::SKAT, envir = ENV, ...)
}
\arguments{
\item{f}{SKAT_Null_Model formula.  If this is non NULL, envir$obj is initialized by calling
SKAT_Null_Model(f, out_type = ty).  If you need to specify additional arguments to the Model
viz. (data, Adjustment, n.Resampling, type.Resampling)
or need to use a different model viz. SKAT_NULL_emmaX, \cr SKAT_Null_Model_ChrX
set the formula to NULL, then before Mega2SKAT is called, build the model you need and
assign it to ENV$obj.}

\item{ty}{type of phenotype C/D = Continuous/Binary 5 (internal type 1/2)}

\item{gs}{a subrange of the default transcripts (refRanges) over which to calculate
the \emph{DOSKAT} function.}

\item{genes}{a list of genes over which to calculate the \emph{DOSKAT} function.
The value, "*", means use all the transcripts in the selected Bioconductor database.
If genes is NULL, the gs range of the internal \emph{refRanges} will be used.}

\item{skat}{alternate SKAT function, viz. SKATBinary, SKAT_CommonRare.  If it is also
necessary is to pass additional arguments to the SKAT function, they may be added to the end
of the Mega2SKAT function and will be passed.  See examples}

\item{envir}{'environment' containing SQLite database and other globals}

\item{...}{extra arguments for SKAT}
}
\value{
None
 the data frame with the results is stored in the environment and named \emph{SKAT_results},
 viz. envir$SKAT_results
}
\description{
Execute the SKAT function on the first \emph{gs} default gene transcripts (gs = 1:100).
 Update the \emph{envir$SKAT_results} data frame with the results.
}
\note{
The \code{SKAT_Null_Model} is called if the formula, f, is not NULL.  A helper function
 \code{SKAT3arg} is defined for the 3 argument callback function which in turn calls
 \code{DOSKAT} with the appropriate arguments (including those additional to the
 \code{Mega2SKAT} function).
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = init_SKAT(db, verbose = FALSE, allMarkers = FALSE)
ENV$verbose = FALSE
ENV$SKAT_results = ENV$SKAT_results[0, ]
Mega2SKAT(ENV$phe[, 3] - 1 ~ 1, "D", kernel = "linear.weighted", 
          weights.beta = c(0.5, 0.5), gs=50:60 )

\donttest{
# donttestcheck: try this below if there is time
 Mega2SKAT(ENV$phe[, 3] - 1 ~ 1, "D", kernel = "linear.weighted", 
           weights.beta = c(0.5, 0.5), genes=c("CEP104") )
}

ENV$SKAT_results

}
\seealso{
\code{\link{init_SKAT}}
}
