% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_divw-methods.R
\docType{methods}
\name{mr_divw}
\alias{mr_divw}
\alias{mr_divw,MRInput-method}
\title{Debiased inverse-variance weighted method}
\usage{
mr_divw(object, over.dispersion = TRUE, alpha = 0.05, diagnostics = FALSE)

\S4method{mr_divw}{MRInput}(object, over.dispersion = TRUE, alpha = 0.05, diagnostics = FALSE)
}
\arguments{
\item{object}{An \code{MRInput} object.}

\item{over.dispersion}{Should the method consider overdispersion (balanced horizontal pleiotropy)? Default is TRUE.}

\item{alpha}{The significance level used to calculate the confidence intervals. The default value is 0.05.}

\item{diagnostics}{Should the function returns the q-q plot for assumption diagnosis. Default is FALSE.}
}
\value{
The output from the function is a \code{DIVW} object containing:

 \item{Over.dispersion}{\code{TRUE} if the method has considered balanced horizontal pleiotropy, \code{FALSE} otherwise.}
 \item{Exposure}{A character string giving the name given to the exposure.}
 \item{Outcome}{A character string giving the name given to the outcome.}
 \item{Estimate}{The value of the causal estimate.}
 \item{StdError}{Standard error of the causal estimate calculated using bootstrapping.}
 \item{CILower}{The lower bound for the causal estimate based on the estimated standard error and the significance level provided.}
 \item{CIUpper}{The upper bound for the causal estimate based on the estimated standard error and the significance level provided.}
 \item{Alpha}{The significance level used when calculating the confidence intervals.}
 \item{Pvalue}{The p-value associated with the estimate (calculated using \code{Estimate/StdError} as per a Wald test) using a normal distribution.}
 \item{SNPs}{The number of genetic variants (SNPs) included in the analysis.}
 \item{Condition}{A measure (average F-statistic -1)*sqrt(# snps) that needs to be large for reliable asymptotic approximation based on the dIVW estimator. It is recommended to be greater than 20.}
}
\description{
The \code{mr_divw} function implements the debiased inverse-variance weighted method.
}
\details{
The debiased inverse-variance weighted method (dIVW) removes the weak instrument bias of the IVW method and is more robust under many weak instruments.
}
\examples{
mr_divw(mr_input(bx = ldlc, bxse = ldlcse, by = chdlodds, byse = chdloddsse))

}
\references{
Ting Ye, Jun Shao, Hyunseung Kang (2021). Debiased Inverse-Variance Weighted Estimator in
Two-Sample Summary-Data Mendelian Randomization. The Annals of Statistics, 49(4), 2079-2100. Also available at \url{https://arxiv.org/abs/1911.09802}.
}
