% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{meshArea}
\alias{meshArea}
\title{Mesh area}
\usage{
meshArea(mesh)
}
\arguments{
\item{mesh}{a mesh given either as a list containing (at least) the two fields 
\code{vertices} (numeric matrix with three columns) and \code{faces} (integer 
matrix or list of integer vectors), otherwise as a \strong{rgl} mesh (i.e. a 
\code{mesh3d} object)}
}
\value{
A number, the surface area of the mesh.
}
\description{
Computes the surface area a mesh.
}
\examples{
library(MeshesTools)
R <- 4; r <- 2
mesh <- torusMesh(R, r)
meshArea(mesh)
# true area of the torus: 
4 * pi^2 * R * r
}
