% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetAlyzer_handler.R
\name{filterMetabolites}
\alias{filterMetabolites}
\title{Filter metabolites}
\usage{
filterMetabolites(
  metalyzer_se,
  drop_metabolites = c("Metabolism Indicators"),
  drop_NA_concentration = FALSE,
  drop_quant_status = NULL,
  min_percent_valid = NULL,
  valid_status = c("Valid", "LOQ"),
  per_group = NULL,
  inplace = FALSE
)
}
\arguments{
\item{metalyzer_se}{SummarizedExperiment}

\item{drop_metabolites}{A character vector defining metabolite classes
or individual metabolites to be removed}

\item{drop_NA_concentration}{A boolean whether to drop metabolites which have
any NAs in their concentration value}

\item{drop_quant_status}{A character, vector of characters or list of
characters specifying which quantification status to remove. Metabolites with
at least one quantification status of this vector will be removed.}

\item{min_percent_valid}{A numeric lower threshold between 0 and 1 (t less than or equal to x) to
remove invalid metabolites that do not meet a given percentage of valid
measurements per group (default per Metabolite).}

\item{valid_status}{A character vector that defines which quantification
status is considered valid.}

\item{per_group}{A character vector of column names from meta_data that will
be used to split each metabolite into groups. The threshold
`min_percent_valid` will be applied for each group. The selected columns from
meta_data will be added to aggregated_data.}

\item{inplace}{If FALSE, return a copy. Otherwise, do operation inplace
and return None.}
}
\value{
An updated SummarizedExperiment
}
\description{
This function filters out certain classes or metabolites
of the metabolites vector. If aggregated_data is not empty,
metabolites and class will also be filtered here.
}
\examples{
metalyzer_se <- MetAlyzer_dataset(file_path = example_extraction_data())

drop_metabolites <- c("C0", "C2", "C3", "Metabolism Indicators",
  inplace = TRUE
)
metalyzer_se <- filterMetabolites(metalyzer_se, drop_metabolites)
# or
filterMetabolites(metalyzer_se, drop_metabolites, inplace = TRUE)
}
