% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPredictions.R
\name{getPredicitons}
\alias{getPredicitons}
\title{Get MetaClean Predictions}
\usage{
getPredicitons(model, testData, eicColumn)
}
\arguments{
\item{model}{The train MetaClean model object.}

\item{testData}{dataframe. Rows should correspond to peaks, columns should include peak quality metrics and EIC column only.}

\item{eicColumn}{name of the EIC column}
}
\value{
a dataframe with four columns: EIC, Pred_Class, Pred_Prob_Pass, Pred_Prob_Fail
}
\description{
Wrapper function for retrieving predictions from a trained MetaClean classifier and a test dataset. Returns a data frame with class
predictions as well as the associated probabilities for each class prediciton.
}
\examples{
# train classification algorithms
\donttest{best_model <- getPredictions(model = mc_model,
                                       testData = pqm_test,
                                       eicColumn = "EICNo")}

}
