% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-from_formula.R
\name{searchFormulaWeb}
\alias{searchFormulaWeb}
\title{Find web hits for a molecular formula}
\usage{
searchFormulaWeb(
  formulas,
  search = c("pubchem", "chemspider", "knapsack", "supernatural2", "chemidplus"),
  apikey = "",
  detailed = TRUE
)
}
\arguments{
\item{formulas}{Character vector of formulas to check}

\item{search}{Which databases to check?, Default: c("PubChem", "ChemSpider")}

\item{apikey}{API key for ChemSpider}

\item{detailed}{Find detailed results? Not just the compound name, but other associated info?, Default: FALSE}
}
\value{
Data table with match results.
}
\description{
Takes molecular formula, and scours PubChem and/or ChemSpider for compounds matching that formula.
}
\examples{
\dontrun{searchFormulaWeb(formulas = c("C6H12O6"),
search = c("pubchem", "chemspider",
"knapsack", "supernatural2",
"chemidplus"), detailed = TRUE)}
}
\seealso{
\code{\link[pbapply]{pbapply}}
 \code{\link[data.table]{as.data.table}},\code{\link[data.table]{rbindlist}}
 \code{\link[enviPat]{check_chemform}}
 \code{\link[gsubfn]{fn}}
 \code{\link[stringr]{str_extract}},\code{\link[stringr]{str_match}}
 \code{\link[XML]{readHTMLTable}}
 \code{\link[rlist]{list.clean}}
 \code{\link[jsonlite]{read_json}}
 \code{\link[httr]{POST}},\code{\link[httr]{add_headers}},\code{\link[httr]{content_type}},\code{\link[httr]{content}},\code{\link[httr]{GET}}
 \code{\link[RJSONIO]{fromJSON}}
}
